--
-- PostgreSQL database dump
--

-- Dumped from database version 14.2
-- Dumped by pg_dump version 14.2

-- Started on 2022-08-25 14:58:21

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- TOC entry 18 (class 2615 OID 2453887)
-- Name: a_aeropuerto_superficie; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA a_aeropuerto_superficie;


ALTER SCHEMA a_aeropuerto_superficie OWNER TO postgres;

--
-- TOC entry 30 (class 2615 OID 2453888)
-- Name: catalogo_objetos; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA catalogo_objetos;


ALTER SCHEMA catalogo_objetos OWNER TO postgres;

--
-- TOC entry 17 (class 2615 OID 2453889)
-- Name: d_linderos_propiedad; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA d_linderos_propiedad;


ALTER SCHEMA d_linderos_propiedad OWNER TO postgres;

--
-- TOC entry 32 (class 2615 OID 2453890)
-- Name: gs_asociado_poblados; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_asociado_poblados;


ALTER SCHEMA gs_asociado_poblados OWNER TO postgres;

--
-- TOC entry 11 (class 2615 OID 2453891)
-- Name: gs_construcciones; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_construcciones;


ALTER SCHEMA gs_construcciones OWNER TO postgres;

--
-- TOC entry 31 (class 2615 OID 2453892)
-- Name: gs_recreacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA gs_recreacion;


ALTER SCHEMA gs_recreacion OWNER TO postgres;

--
-- TOC entry 28 (class 2615 OID 2453893)
-- Name: ho_aguas_interiores; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_aguas_interiores;


ALTER SCHEMA ho_aguas_interiores OWNER TO postgres;

--
-- TOC entry 25 (class 2615 OID 2453894)
-- Name: ho_puertos_muelles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_puertos_muelles;


ALTER SCHEMA ho_puertos_muelles OWNER TO postgres;

--
-- TOC entry 14 (class 2615 OID 2453895)
-- Name: ho_regulacion_zonas_restringidas; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_regulacion_zonas_restringidas;


ALTER SCHEMA ho_regulacion_zonas_restringidas OWNER TO postgres;

--
-- TOC entry 12 (class 2615 OID 2453896)
-- Name: ho_zonas_costeras; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ho_zonas_costeras;


ALTER SCHEMA ho_zonas_costeras OWNER TO postgres;

--
-- TOC entry 24 (class 2615 OID 2453897)
-- Name: ii_agropecuaria; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA ii_agropecuaria;


ALTER SCHEMA ii_agropecuaria OWNER TO postgres;

--
-- TOC entry 13 (class 2615 OID 2453898)
-- Name: it_asociado_transportacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_asociado_transportacion;


ALTER SCHEMA it_asociado_transportacion OWNER TO postgres;

--
-- TOC entry 26 (class 2615 OID 2453899)
-- Name: it_cruces_enlaces; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_cruces_enlaces;


ALTER SCHEMA it_cruces_enlaces OWNER TO postgres;

--
-- TOC entry 16 (class 2615 OID 2453900)
-- Name: it_ferrocarriles; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_ferrocarriles;


ALTER SCHEMA it_ferrocarriles OWNER TO postgres;

--
-- TOC entry 29 (class 2615 OID 2453901)
-- Name: it_transporte_terrestre; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA it_transporte_terrestre;


ALTER SCHEMA it_transporte_terrestre OWNER TO postgres;

--
-- TOC entry 19 (class 2615 OID 2453902)
-- Name: proyecto_qgis3; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA proyecto_qgis3;


ALTER SCHEMA proyecto_qgis3 OWNER TO postgres;

--
-- TOC entry 27 (class 2615 OID 2453903)
-- Name: visualizacion; Type: SCHEMA; Schema: -; Owner: postgres
--

CREATE SCHEMA visualizacion;


ALTER SCHEMA visualizacion OWNER TO postgres;

--
-- TOC entry 6 (class 3079 OID 17619)
-- Name: address_standardizer; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS address_standardizer WITH SCHEMA public;


--
-- TOC entry 7444 (class 0 OID 0)
-- Dependencies: 6
-- Name: EXTENSION address_standardizer; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION address_standardizer IS 'Used to parse an address into constituent elements. Generally used to support geocoding address normalization step.';


--
-- TOC entry 5 (class 3079 OID 17608)
-- Name: fuzzystrmatch; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS fuzzystrmatch WITH SCHEMA public;


--
-- TOC entry 7445 (class 0 OID 0)
-- Dependencies: 5
-- Name: EXTENSION fuzzystrmatch; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION fuzzystrmatch IS 'determine similarities and distance between strings';


--
-- TOC entry 2 (class 3079 OID 16386)
-- Name: postgis; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis WITH SCHEMA public;


--
-- TOC entry 7446 (class 0 OID 0)
-- Dependencies: 2
-- Name: EXTENSION postgis; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis IS 'PostGIS geometry and geography spatial types and functions';


--
-- TOC entry 8 (class 3079 OID 18036)
-- Name: postgis_raster; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_raster WITH SCHEMA public;


--
-- TOC entry 7447 (class 0 OID 0)
-- Dependencies: 8
-- Name: EXTENSION postgis_raster; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_raster IS 'PostGIS raster types and functions';


--
-- TOC entry 4 (class 3079 OID 17581)
-- Name: postgis_sfcgal; Type: EXTENSION; Schema: -; Owner: -
--

CREATE EXTENSION IF NOT EXISTS postgis_sfcgal WITH SCHEMA public;


--
-- TOC entry 7448 (class 0 OID 0)
-- Dependencies: 4
-- Name: EXTENSION postgis_sfcgal; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION postgis_sfcgal IS 'PostGIS SFCGAL functions';

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- TOC entry 309 (class 1259 OID 2453904)
-- Name: aeropuerto_a; Type: TABLE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE TABLE a_aeropuerto_superficie.aeropuerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'GB005'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    iko character varying(4),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'GB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 7451 (class 0 OID 0)
-- Dependencies: 309
-- Name: TABLE aeropuerto_a; Type: COMMENT; Schema: a_aeropuerto_superficie; Owner: postgres
--

COMMENT ON TABLE a_aeropuerto_superficie.aeropuerto_a IS 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.';


--
-- TOC entry 310 (class 1259 OID 2453915)
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7452 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER SEQUENCE a_aeropuerto_superficie.aeropuerto_a_gid_seq OWNED BY a_aeropuerto_superficie.aeropuerto_a.gid;


--
-- TOC entry 311 (class 1259 OID 2453916)
-- Name: acc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.acc (
    acc integer NOT NULL,
    acc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.acc OWNER TO postgres;

--
-- TOC entry 312 (class 1259 OID 2453919)
-- Name: atc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.atc (
    atc integer NOT NULL,
    atc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.atc OWNER TO postgres;

--
-- TOC entry 313 (class 1259 OID 2453922)
-- Name: bsc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.bsc (
    bsc integer NOT NULL,
    bsc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.bsc OWNER TO postgres;

--
-- TOC entry 314 (class 1259 OID 2453925)
-- Name: catalogo_objetos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.catalogo_objetos (
    fcode character varying(5) NOT NULL,
    objeto character varying(80),
    descripcion character varying(350),
    gid integer NOT NULL
);


ALTER TABLE catalogo_objetos.catalogo_objetos OWNER TO postgres;

--
-- TOC entry 315 (class 1259 OID 2453928)
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE; Schema: catalogo_objetos; Owner: postgres
--

CREATE SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE catalogo_objetos.catalogo_objetos_gid_seq OWNER TO postgres;

--
-- TOC entry 7453 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE OWNED BY; Schema: catalogo_objetos; Owner: postgres
--

ALTER SEQUENCE catalogo_objetos.catalogo_objetos_gid_seq OWNED BY catalogo_objetos.catalogo_objetos.gid;


--
-- TOC entry 316 (class 1259 OID 2453929)
-- Name: dit; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.dit (
    dit integer NOT NULL,
    dit_desc character varying(80)
);


ALTER TABLE catalogo_objetos.dit OWNER TO postgres;

--
-- TOC entry 317 (class 1259 OID 2453932)
-- Name: ela; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.ela (
    ela integer NOT NULL,
    ela_desc character varying(80)
);


ALTER TABLE catalogo_objetos.ela OWNER TO postgres;

--
-- TOC entry 318 (class 1259 OID 2453935)
-- Name: fco; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fco (
    fco integer NOT NULL,
    fco_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fco OWNER TO postgres;

--
-- TOC entry 319 (class 1259 OID 2453938)
-- Name: fti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fti (
    fti integer NOT NULL,
    fti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fti OWNER TO postgres;

--
-- TOC entry 320 (class 1259 OID 2453941)
-- Name: fuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.fuc (
    fuc integer NOT NULL,
    fuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.fuc OWNER TO postgres;

--
-- TOC entry 321 (class 1259 OID 2453944)
-- Name: hct; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hct (
    hct integer NOT NULL,
    hct_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hct OWNER TO postgres;

--
-- TOC entry 322 (class 1259 OID 2453947)
-- Name: hyp; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.hyp (
    hyp integer NOT NULL,
    hyp_desc character varying(80)
);


ALTER TABLE catalogo_objetos.hyp OWNER TO postgres;

--
-- TOC entry 323 (class 1259 OID 2453950)
-- Name: kos; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.kos (
    kos integer NOT NULL,
    kos_desc character varying(80)
);


ALTER TABLE catalogo_objetos.kos OWNER TO postgres;

--
-- TOC entry 324 (class 1259 OID 2453953)
-- Name: loc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.loc (
    loc integer NOT NULL,
    loc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.loc OWNER TO postgres;

--
-- TOC entry 325 (class 1259 OID 2453956)
-- Name: mes; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.mes (
    mes integer NOT NULL,
    mes_desc character varying(80)
);


ALTER TABLE catalogo_objetos.mes OWNER TO postgres;

--
-- TOC entry 326 (class 1259 OID 2453959)
-- Name: rdt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rdt (
    rdt integer NOT NULL,
    rdt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rdt OWNER TO postgres;

--
-- TOC entry 327 (class 1259 OID 2453962)
-- Name: rel; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rel (
    rel integer NOT NULL,
    rel_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rel OWNER TO postgres;

--
-- TOC entry 328 (class 1259 OID 2453965)
-- Name: rgc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rgc (
    rgc integer NOT NULL,
    rgc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rgc OWNER TO postgres;

--
-- TOC entry 329 (class 1259 OID 2453968)
-- Name: rra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rra (
    rra integer NOT NULL,
    rra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rra OWNER TO postgres;

--
-- TOC entry 330 (class 1259 OID 2453971)
-- Name: rrc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rrc (
    rrc integer NOT NULL,
    rrc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rrc OWNER TO postgres;

--
-- TOC entry 331 (class 1259 OID 2453974)
-- Name: rst; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.rst (
    rst integer NOT NULL,
    rst_desc character varying(80)
);


ALTER TABLE catalogo_objetos.rst OWNER TO postgres;

--
-- TOC entry 332 (class 1259 OID 2453977)
-- Name: slt; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.slt (
    slt integer NOT NULL,
    slt_desc character varying(80)
);


ALTER TABLE catalogo_objetos.slt OWNER TO postgres;

--
-- TOC entry 333 (class 1259 OID 2453980)
-- Name: smc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.smc (
    smc integer NOT NULL,
    smc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.smc OWNER TO postgres;

--
-- TOC entry 334 (class 1259 OID 2453983)
-- Name: tra; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tra (
    tra integer NOT NULL,
    tra_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tra OWNER TO postgres;

--
-- TOC entry 335 (class 1259 OID 2453986)
-- Name: tuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.tuc (
    tuc integer NOT NULL,
    tuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.tuc OWNER TO postgres;

--
-- TOC entry 336 (class 1259 OID 2453989)
-- Name: typ; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.typ (
    typ integer NOT NULL,
    typ_desc character varying(80)
);


ALTER TABLE catalogo_objetos.typ OWNER TO postgres;

--
-- TOC entry 337 (class 1259 OID 2453992)
-- Name: uuc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.uuc (
    uuc integer NOT NULL,
    uuc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.uuc OWNER TO postgres;

--
-- TOC entry 338 (class 1259 OID 2453995)
-- Name: wtc; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wtc (
    wtc integer NOT NULL,
    wtc_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wtc OWNER TO postgres;

--
-- TOC entry 339 (class 1259 OID 2453998)
-- Name: wti; Type: TABLE; Schema: catalogo_objetos; Owner: postgres
--

CREATE TABLE catalogo_objetos.wti (
    wti integer NOT NULL,
    wti_desc character varying(80)
);


ALTER TABLE catalogo_objetos.wti OWNER TO postgres;

--
-- TOC entry 340 (class 1259 OID 2454001)
-- Name: punto_control_p; Type: TABLE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE TABLE d_linderos_propiedad.punto_control_p (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'ZB050'::character varying NOT NULL,
    acc integer NOT NULL,
    ela integer NOT NULL,
    zvh double precision,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'POINT'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'ZB050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE d_linderos_propiedad.punto_control_p OWNER TO postgres;

--
-- TOC entry 7454 (class 0 OID 0)
-- Dependencies: 340
-- Name: TABLE punto_control_p; Type: COMMENT; Schema: d_linderos_propiedad; Owner: postgres
--

COMMENT ON TABLE d_linderos_propiedad.punto_control_p IS 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.';


--
-- TOC entry 341 (class 1259 OID 2454012)
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNER TO postgres;

--
-- TOC entry 7455 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE OWNED BY; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER SEQUENCE d_linderos_propiedad.vertice_geodesico_p_gid_seq OWNED BY d_linderos_propiedad.punto_control_p.gid;


--
-- TOC entry 342 (class 1259 OID 2454013)
-- Name: cementerio_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cementerio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL030'::character varying NOT NULL,
    nam character varying(80),
    rel integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cementerio_a OWNER TO postgres;

--
-- TOC entry 7456 (class 0 OID 0)
-- Dependencies: 342
-- Name: TABLE cementerio_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cementerio_a IS 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.';


--
-- TOC entry 343 (class 1259 OID 2454024)
-- Name: cementerio_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cementerio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7457 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cementerio_a_gid_seq OWNED BY gs_asociado_poblados.cementerio_a.gid;


--
-- TOC entry 344 (class 1259 OID 2454025)
-- Name: cerca_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.cerca_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL070'::character varying NOT NULL,
    fti integer NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL070'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.cerca_l OWNER TO postgres;

--
-- TOC entry 7458 (class 0 OID 0)
-- Dependencies: 344
-- Name: TABLE cerca_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.cerca_l IS 'Barrera artificial construida por el hombre, de estructura relativamente liviana y que es utilizada como cercado o límite.';


--
-- TOC entry 345 (class 1259 OID 2454036)
-- Name: cerca_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.cerca_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.cerca_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7459 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.cerca_l_gid_seq OWNED BY gs_asociado_poblados.cerca_l.gid;


--
-- TOC entry 346 (class 1259 OID 2454037)
-- Name: escalinata_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.escalinata_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ150'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ150'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.escalinata_a OWNER TO postgres;

--
-- TOC entry 7460 (class 0 OID 0)
-- Dependencies: 346
-- Name: TABLE escalinata_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.escalinata_a IS 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior. Para fines catastrales se levantarán únicamente las escalinatas públicas que permitan identificar el lindero de un predio.';


--
-- TOC entry 347 (class 1259 OID 2454048)
-- Name: escalinata_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.escalinata_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7461 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.escalinata_a_gid_seq OWNED BY gs_asociado_poblados.escalinata_a.gid;


--
-- TOC entry 348 (class 1259 OID 2454049)
-- Name: muro_l; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.muro_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL260'::character varying NOT NULL,
    wti integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL260'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.muro_l OWNER TO postgres;

--
-- TOC entry 7462 (class 0 OID 0)
-- Dependencies: 348
-- Name: TABLE muro_l; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.muro_l IS 'Barrera hecha por el hombre de material resistente y que es utilizado como límite o para protección. Es aquel objeto que permite identificar el lindero de un predio.';


--
-- TOC entry 349 (class 1259 OID 2454060)
-- Name: muro_l_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.muro_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.muro_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7463 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.muro_l_gid_seq OWNED BY gs_asociado_poblados.muro_l.gid;


--
-- TOC entry 350 (class 1259 OID 2454061)
-- Name: plaza_publica_a; Type: TABLE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE TABLE gs_asociado_poblados.plaza_publica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL170'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_asociado_poblados.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 7464 (class 0 OID 0)
-- Dependencies: 350
-- Name: TABLE plaza_publica_a; Type: COMMENT; Schema: gs_asociado_poblados; Owner: postgres
--

COMMENT ON TABLE gs_asociado_poblados.plaza_publica_a IS 'Sitio abierto que sirve como lugar de reunión pública, en una zona poblada para diversos usos.';


--
-- TOC entry 351 (class 1259 OID 2454072)
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_asociado_poblados.plaza_publica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7465 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER SEQUENCE gs_asociado_poblados.plaza_publica_a_gid_seq OWNED BY gs_asociado_poblados.plaza_publica_a.gid;


--
-- TOC entry 352 (class 1259 OID 2454073)
-- Name: edificio_a; Type: TABLE; Schema: gs_construcciones; Owner: postgres
--

CREATE TABLE gs_construcciones.edificio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AL015'::character varying NOT NULL,
    nam character varying(200),
    acc integer NOT NULL,
    uuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AL015'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_construcciones.edificio_a OWNER TO postgres;

--
-- TOC entry 7466 (class 0 OID 0)
-- Dependencies: 352
-- Name: TABLE edificio_a; Type: COMMENT; Schema: gs_construcciones; Owner: postgres
--

COMMENT ON TABLE gs_construcciones.edificio_a IS 'Construcción independiente, techada, generalmente con paredes; destinada al hábitat y/o actividades de personas. Para fines catastrales se incluye choza, misma que deberá ser catalogada en el atributo txt como "Choza".';


--
-- TOC entry 353 (class 1259 OID 2454084)
-- Name: edificio_a_gid_seq; Type: SEQUENCE; Schema: gs_construcciones; Owner: postgres
--

CREATE SEQUENCE gs_construcciones.edificio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_construcciones.edificio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7467 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_construcciones; Owner: postgres
--

ALTER SEQUENCE gs_construcciones.edificio_a_gid_seq OWNED BY gs_construcciones.edificio_a.gid;


--
-- TOC entry 354 (class 1259 OID 2454085)
-- Name: cancha_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.cancha_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK040'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    kos integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.cancha_a OWNER TO postgres;

--
-- TOC entry 7468 (class 0 OID 0)
-- Dependencies: 354
-- Name: TABLE cancha_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.cancha_a IS 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.';


--
-- TOC entry 355 (class 1259 OID 2454096)
-- Name: cancha_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.cancha_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.cancha_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7469 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.cancha_a_gid_seq OWNED BY gs_recreacion.cancha_a.gid;


--
-- TOC entry 356 (class 1259 OID 2454097)
-- Name: estadio_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.estadio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK165'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK165'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.estadio_a OWNER TO postgres;

--
-- TOC entry 7470 (class 0 OID 0)
-- Dependencies: 356
-- Name: TABLE estadio_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.estadio_a IS 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).';


--
-- TOC entry 357 (class 1259 OID 2454108)
-- Name: estadio_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.estadio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.estadio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7471 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.estadio_a_gid_seq OWNED BY gs_recreacion.estadio_a.gid;


--
-- TOC entry 358 (class 1259 OID 2454109)
-- Name: parque_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.parque_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK120'::character varying NOT NULL,
    nam character varying(80),
    fuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK120'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.parque_a OWNER TO postgres;

--
-- TOC entry 7472 (class 0 OID 0)
-- Dependencies: 358
-- Name: TABLE parque_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.parque_a IS 'Área utilizada con propósitos recreacionales u ornamentales.';


--
-- TOC entry 359 (class 1259 OID 2454120)
-- Name: parque_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.parque_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.parque_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7473 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.parque_a_gid_seq OWNED BY gs_recreacion.parque_a.gid;


--
-- TOC entry 360 (class 1259 OID 2454121)
-- Name: piscina_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.piscina_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.piscina_a OWNER TO postgres;

--
-- TOC entry 7474 (class 0 OID 0)
-- Dependencies: 360
-- Name: TABLE piscina_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.piscina_a IS 'Construcción destinada a contener agua con fines de recreación y natación.';


--
-- TOC entry 361 (class 1259 OID 2454132)
-- Name: piscina_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.piscina_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.piscina_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7475 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.piscina_a_gid_seq OWNED BY gs_recreacion.piscina_a.gid;


--
-- TOC entry 362 (class 1259 OID 2454133)
-- Name: plaza_toros_a; Type: TABLE; Schema: gs_recreacion; Owner: postgres
--

CREATE TABLE gs_recreacion.plaza_toros_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AK166'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AK166'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE gs_recreacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 7476 (class 0 OID 0)
-- Dependencies: 362
-- Name: TABLE plaza_toros_a; Type: COMMENT; Schema: gs_recreacion; Owner: postgres
--

COMMENT ON TABLE gs_recreacion.plaza_toros_a IS 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.';


--
-- TOC entry 363 (class 1259 OID 2454144)
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE; Schema: gs_recreacion; Owner: postgres
--

CREATE SEQUENCE gs_recreacion.plaza_toros_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE gs_recreacion.plaza_toros_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7477 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: gs_recreacion; Owner: postgres
--

ALTER SEQUENCE gs_recreacion.plaza_toros_a_gid_seq OWNED BY gs_recreacion.plaza_toros_a.gid;


--
-- TOC entry 364 (class 1259 OID 2454145)
-- Name: acequia_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acequia_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH030'::character varying NOT NULL,
    hyp integer NOT NULL,
    dit integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acequia_l OWNER TO postgres;

--
-- TOC entry 7478 (class 0 OID 0)
-- Dependencies: 364
-- Name: TABLE acequia_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acequia_l IS 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación. Se debe levantar los dos lados de la acequia, no únicamente el eje. ';


--
-- TOC entry 365 (class 1259 OID 2454156)
-- Name: acequia_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acequia_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acequia_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7479 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acequia_l_gid_seq OWNED BY ho_aguas_interiores.acequia_l.gid;


--
-- TOC entry 366 (class 1259 OID 2454157)
-- Name: acueducto_canal_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.acueducto_canal_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH010'::character varying NOT NULL,
    atc integer NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 7480 (class 0 OID 0)
-- Dependencies: 366
-- Name: TABLE acueducto_canal_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.acueducto_canal_a IS 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos. ';


--
-- TOC entry 367 (class 1259 OID 2454168)
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7481 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.acueducto_canal_a_gid_seq OWNED BY ho_aguas_interiores.acueducto_canal_a.gid;


--
-- TOC entry 368 (class 1259 OID 2454169)
-- Name: lago_laguna_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.lago_laguna_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH080'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH080'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 7482 (class 0 OID 0)
-- Dependencies: 368
-- Name: TABLE lago_laguna_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.lago_laguna_a IS 'Cuerpo de agua, dulce o salada que se encuentra rodeada por tierra.';


--
-- TOC entry 369 (class 1259 OID 2454180)
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.lago_laguna_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7483 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.lago_laguna_a_gid_seq OWNED BY ho_aguas_interiores.lago_laguna_a.gid;


--
-- TOC entry 370 (class 1259 OID 2454181)
-- Name: rio_a; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_a OWNER TO postgres;

--
-- TOC entry 7484 (class 0 OID 0)
-- Dependencies: 370
-- Name: TABLE rio_a; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_a IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 371 (class 1259 OID 2454192)
-- Name: rio_a_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7485 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_a_gid_seq OWNED BY ho_aguas_interiores.rio_a.gid;


--
-- TOC entry 372 (class 1259 OID 2454193)
-- Name: rio_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.rio_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH140'::character varying NOT NULL,
    nam character varying(100),
    na2 character varying(80),
    acc integer NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.rio_l OWNER TO postgres;

--
-- TOC entry 7486 (class 0 OID 0)
-- Dependencies: 372
-- Name: TABLE rio_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.rio_l IS 'Curso de agua que fluye naturalmente.';


--
-- TOC entry 373 (class 1259 OID 2454204)
-- Name: rio_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.rio_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.rio_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7487 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.rio_l_gid_seq OWNED BY ho_aguas_interiores.rio_l.gid;


--
-- TOC entry 374 (class 1259 OID 2454205)
-- Name: zanja_l; Type: TABLE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE TABLE ho_aguas_interiores.zanja_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH100'::character varying NOT NULL,
    hyp integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH100'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_aguas_interiores.zanja_l OWNER TO postgres;

--
-- TOC entry 7488 (class 0 OID 0)
-- Dependencies: 374
-- Name: TABLE zanja_l; Type: COMMENT; Schema: ho_aguas_interiores; Owner: postgres
--

COMMENT ON TABLE ho_aguas_interiores.zanja_l IS 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes. Se debe levantar los dos lados de la zanja, no únicamente el eje. ';


--
-- TOC entry 375 (class 1259 OID 2454216)
-- Name: zanja_l_gid_seq; Type: SEQUENCE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE SEQUENCE ho_aguas_interiores.zanja_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_aguas_interiores.zanja_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7489 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER SEQUENCE ho_aguas_interiores.zanja_l_gid_seq OWNED BY ho_aguas_interiores.zanja_l.gid;


--
-- TOC entry 376 (class 1259 OID 2454217)
-- Name: puerto_a; Type: TABLE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE TABLE ho_puertos_muelles.puerto_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BB005'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BB005'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_puertos_muelles.puerto_a OWNER TO postgres;

--
-- TOC entry 7490 (class 0 OID 0)
-- Dependencies: 376
-- Name: TABLE puerto_a; Type: COMMENT; Schema: ho_puertos_muelles; Owner: postgres
--

COMMENT ON TABLE ho_puertos_muelles.puerto_a IS 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de pasajeros.';


--
-- TOC entry 377 (class 1259 OID 2454228)
-- Name: puerto_a_gid_seq; Type: SEQUENCE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE SEQUENCE ho_puertos_muelles.puerto_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_puertos_muelles.puerto_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7491 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER SEQUENCE ho_puertos_muelles.puerto_a_gid_seq OWNED BY ho_puertos_muelles.puerto_a.gid;


--
-- TOC entry 378 (class 1259 OID 2454229)
-- Name: granja_acuatica_a; Type: TABLE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BH050'::character varying NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BH050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 7492 (class 0 OID 0)
-- Dependencies: 378
-- Name: TABLE granja_acuatica_a; Type: COMMENT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

COMMENT ON TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a IS 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares. ';


--
-- TOC entry 379 (class 1259 OID 2454240)
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7493 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER SEQUENCE ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq OWNED BY ho_regulacion_zonas_restringidas.granja_acuatica_a.gid;


--
-- TOC entry 380 (class 1259 OID 2454241)
-- Name: isla_a; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.isla_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.isla_a OWNER TO postgres;

--
-- TOC entry 7494 (class 0 OID 0)
-- Dependencies: 380
-- Name: TABLE isla_a; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.isla_a IS 'Masa de tierra más pequeña que un continente y que está rodeada por agua.';


--
-- TOC entry 381 (class 1259 OID 2454252)
-- Name: isla_a_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.isla_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.isla_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7495 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.isla_a_gid_seq OWNED BY ho_zonas_costeras.isla_a.gid;


--
-- TOC entry 382 (class 1259 OID 2454253)
-- Name: orilla_l; Type: TABLE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE TABLE ho_zonas_costeras.orilla_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'BA010'::character varying NOT NULL,
    acc integer NOT NULL,
    slt integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'BA010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ho_zonas_costeras.orilla_l OWNER TO postgres;

--
-- TOC entry 7496 (class 0 OID 0)
-- Dependencies: 382
-- Name: TABLE orilla_l; Type: COMMENT; Schema: ho_zonas_costeras; Owner: postgres
--

COMMENT ON TABLE ho_zonas_costeras.orilla_l IS 'Línea donde una superficie está en contacto con un cuerpo de agua. ';


--
-- TOC entry 383 (class 1259 OID 2454264)
-- Name: orilla_l_gid_seq; Type: SEQUENCE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE SEQUENCE ho_zonas_costeras.orilla_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ho_zonas_costeras.orilla_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7497 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER SEQUENCE ho_zonas_costeras.orilla_l_gid_seq OWNED BY ho_zonas_costeras.orilla_l.gid;


--
-- TOC entry 384 (class 1259 OID 2454265)
-- Name: invernadero_a; Type: TABLE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE TABLE ii_agropecuaria.invernadero_a (
    gid integer DEFAULT nextval(('ii_agropecuaria.invernadero_a_gid_seq'::text)::regclass) NOT NULL,
    fcode character varying(5) DEFAULT 'AJ110'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AJ110'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE ii_agropecuaria.invernadero_a OWNER TO postgres;

--
-- TOC entry 7498 (class 0 OID 0)
-- Dependencies: 384
-- Name: TABLE invernadero_a; Type: COMMENT; Schema: ii_agropecuaria; Owner: postgres
--

COMMENT ON TABLE ii_agropecuaria.invernadero_a IS 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.';


--
-- TOC entry 385 (class 1259 OID 2454277)
-- Name: invernadero_a_gid_seq; Type: SEQUENCE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE SEQUENCE ii_agropecuaria.invernadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE ii_agropecuaria.invernadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7499 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: ii_agropecuaria; Owner: postgres
--

ALTER SEQUENCE ii_agropecuaria.invernadero_a_gid_seq OWNED BY ii_agropecuaria.invernadero_a.gid;


--
-- TOC entry 386 (class 1259 OID 2454278)
-- Name: acera_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.acera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ035'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ035'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.acera_a OWNER TO postgres;

--
-- TOC entry 7500 (class 0 OID 0)
-- Dependencies: 386
-- Name: TABLE acera_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.acera_a IS 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ';


--
-- TOC entry 387 (class 1259 OID 2454289)
-- Name: acera_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.acera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.acera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7501 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.acera_a_gid_seq OWNED BY it_asociado_transportacion.acera_a.gid;


--
-- TOC entry 388 (class 1259 OID 2454290)
-- Name: bordillo_l; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.bordillo_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ037'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ037'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 7502 (class 0 OID 0)
-- Dependencies: 388
-- Name: TABLE bordillo_l; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.bordillo_l IS 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.';


--
-- TOC entry 389 (class 1259 OID 2454301)
-- Name: bordillo_l_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.bordillo_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7503 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.bordillo_l_gid_seq OWNED BY it_asociado_transportacion.bordillo_l.gid;


--
-- TOC entry 390 (class 1259 OID 2454302)
-- Name: cuneta_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.cuneta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ036'::character varying NOT NULL,
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32717) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ036'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 7504 (class 0 OID 0)
-- Dependencies: 390
-- Name: TABLE cuneta_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.cuneta_a IS 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera. Este objeto tiene el fin de canalizar agua de lluvia que se escurra a lo largo de la vía.';


--
-- TOC entry 391 (class 1259 OID 2454313)
-- Name: cuneta_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.cuneta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7505 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.cuneta_a_gid_seq OWNED BY it_asociado_transportacion.cuneta_a.gid;


--
-- TOC entry 392 (class 1259 OID 2454314)
-- Name: parqueadero_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.parqueadero_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ140'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ140'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 7506 (class 0 OID 0)
-- Dependencies: 392
-- Name: TABLE parqueadero_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.parqueadero_a IS 'Lugar destinado generalmente para estacionar vehículos.';


--
-- TOC entry 393 (class 1259 OID 2454325)
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.parqueadero_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7507 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.parqueadero_a_gid_seq OWNED BY it_asociado_transportacion.parqueadero_a.gid;


--
-- TOC entry 394 (class 1259 OID 2454326)
-- Name: paseo_peatonal_ciclovia_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP031'::character varying NOT NULL,
    nam character varying(80),
    smc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP031'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 7508 (class 0 OID 0)
-- Dependencies: 394
-- Name: TABLE paseo_peatonal_ciclovia_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a IS 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para peatones, animales y/o vehículos no motorizado.';


--
-- TOC entry 395 (class 1259 OID 2454337)
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7509 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq OWNED BY it_asociado_transportacion.paseo_peatonal_ciclovia_a.gid;


--
-- TOC entry 396 (class 1259 OID 2454338)
-- Name: tunel_a; Type: TABLE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE TABLE it_asociado_transportacion.tunel_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ130'::character varying NOT NULL,
    nam character varying(80),
    tra integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32717) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ130'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_asociado_transportacion.tunel_a OWNER TO postgres;

--
-- TOC entry 7510 (class 0 OID 0)
-- Dependencies: 396
-- Name: TABLE tunel_a; Type: COMMENT; Schema: it_asociado_transportacion; Owner: postgres
--

COMMENT ON TABLE it_asociado_transportacion.tunel_a IS 'Paso subterráneo o submarino, abierto para establecer comunicación.';


--
-- TOC entry 397 (class 1259 OID 2454349)
-- Name: tunel_a_gid_seq; Type: SEQUENCE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE SEQUENCE it_asociado_transportacion.tunel_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_asociado_transportacion.tunel_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7511 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER SEQUENCE it_asociado_transportacion.tunel_a_gid_seq OWNED BY it_asociado_transportacion.tunel_a.gid;


--
-- TOC entry 398 (class 1259 OID 2454350)
-- Name: puente_a; Type: TABLE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE TABLE it_cruces_enlaces.puente_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ040'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    bsc integer NOT NULL,
    ltn integer NOT NULL,
    typ integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ040'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_cruces_enlaces.puente_a OWNER TO postgres;

--
-- TOC entry 7512 (class 0 OID 0)
-- Dependencies: 398
-- Name: TABLE puente_a; Type: COMMENT; Schema: it_cruces_enlaces; Owner: postgres
--

COMMENT ON TABLE it_cruces_enlaces.puente_a IS 'Estructura que conecta dos lugares y facilita el paso de una ruta de transporte (por ejemplo: carretera o ferrocarril) sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).';


--
-- TOC entry 399 (class 1259 OID 2454361)
-- Name: puente_a_gid_seq; Type: SEQUENCE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE SEQUENCE it_cruces_enlaces.puente_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_cruces_enlaces.puente_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7513 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER SEQUENCE it_cruces_enlaces.puente_a_gid_seq OWNED BY it_cruces_enlaces.puente_a.gid;


--
-- TOC entry 400 (class 1259 OID 2454362)
-- Name: ferrocarril_a; Type: TABLE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE TABLE it_ferrocarriles.ferrocarril_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AN010'::character varying NOT NULL,
    nam character varying(80),
    acc integer NOT NULL,
    fco integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    rgc integer NOT NULL,
    rra integer NOT NULL,
    rrc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry(MultiPolygon,32717) NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AN010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_ferrocarriles.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 7514 (class 0 OID 0)
-- Dependencies: 400
-- Name: TABLE ferrocarril_a; Type: COMMENT; Schema: it_ferrocarriles; Owner: postgres
--

COMMENT ON TABLE it_ferrocarriles.ferrocarril_a IS 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.';


--
-- TOC entry 401 (class 1259 OID 2454373)
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_ferrocarriles.ferrocarril_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7515 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_ferrocarriles; Owner: postgres
--

ALTER SEQUENCE it_ferrocarriles.ferrocarril_a_gid_seq OWNED BY it_ferrocarriles.ferrocarril_a.gid;


--
-- TOC entry 402 (class 1259 OID 2454374)
-- Name: gasolinera_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.gasolinera_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AQ170'::character varying NOT NULL,
    nam character varying(80),
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AQ170'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.gasolinera_a OWNER TO postgres;

--
-- TOC entry 7516 (class 0 OID 0)
-- Dependencies: 402
-- Name: TABLE gasolinera_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.gasolinera_a IS 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.';


--
-- TOC entry 403 (class 1259 OID 2454385)
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.gasolinera_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7517 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.gasolinera_a_gid_seq OWNED BY it_transporte_terrestre.gasolinera_a.gid;


--
-- TOC entry 404 (class 1259 OID 2454386)
-- Name: intercambiador_vial_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.intercambiador_vial_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP020'::character varying NOT NULL,
    nam character varying(80),
    hct integer NOT NULL,
    rst integer NOT NULL,
    loc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP020'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 7518 (class 0 OID 0)
-- Dependencies: 404
-- Name: TABLE intercambiador_vial_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.intercambiador_vial_a IS 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a otra.';


--
-- TOC entry 405 (class 1259 OID 2454397)
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7519 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.intercambiador_vial_a_gid_seq OWNED BY it_transporte_terrestre.intercambiador_vial_a.gid;


--
-- TOC entry 406 (class 1259 OID 2454398)
-- Name: rodera_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.rodera_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP010'::character varying NOT NULL,
    typ integer NOT NULL,
    rst integer NOT NULL,
    hct integer NOT NULL,
    rdt integer,
    wtc integer NOT NULL,
    ltn integer NOT NULL,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP010'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.rodera_l OWNER TO postgres;

--
-- TOC entry 7520 (class 0 OID 0)
-- Dependencies: 406
-- Name: TABLE rodera_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.rodera_l IS 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.';


--
-- TOC entry 407 (class 1259 OID 2454409)
-- Name: rodera_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.rodera_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.rodera_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7521 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.rodera_l_gid_seq OWNED BY it_transporte_terrestre.rodera_l.gid;


--
-- TOC entry 408 (class 1259 OID 2454410)
-- Name: sendero_l; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.sendero_l (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP050'::character varying NOT NULL,
    wtc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'LINESTRING'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP050'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.sendero_l OWNER TO postgres;

--
-- TOC entry 7522 (class 0 OID 0)
-- Dependencies: 408
-- Name: TABLE sendero_l; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.sendero_l IS 'Camino angosto abierto por el tránsito de personas o animales.';


--
-- TOC entry 409 (class 1259 OID 2454421)
-- Name: sendero_l_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.sendero_l_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.sendero_l_gid_seq OWNER TO postgres;

--
-- TOC entry 7523 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.sendero_l_gid_seq OWNED BY it_transporte_terrestre.sendero_l.gid;


--
-- TOC entry 410 (class 1259 OID 2454422)
-- Name: via_ruta_a; Type: TABLE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE TABLE it_transporte_terrestre.via_ruta_a (
    gid integer NOT NULL,
    fcode character varying(5) DEFAULT 'AP030'::character varying NOT NULL,
    nam character varying(80),
    na2 character varying(80),
    acc integer NOT NULL,
    rst integer NOT NULL,
    typ integer NOT NULL,
    hct integer NOT NULL,
    loc integer NOT NULL,
    ltn integer NOT NULL,
    mes integer NOT NULL,
    rdt integer,
    tuc integer NOT NULL,
    txt character varying(250),
    the_geom public.geometry NOT NULL,
    CONSTRAINT enforce_dims_the_geom CHECK ((public.st_ndims(the_geom) = 2)),
    CONSTRAINT enforce_geotype_the_geom CHECK (((public.geometrytype(the_geom) = 'MULTIPOLYGON'::text) OR (the_geom IS NULL))),
    CONSTRAINT enforce_srid_the_geom CHECK ((public.st_srid(the_geom) = 32717)),
    CONSTRAINT fcode_no_correspondiente CHECK (((fcode)::text = 'AP030'::text)),
    CONSTRAINT geometria_valida CHECK ((public.st_isvalid(the_geom) = true))
);


ALTER TABLE it_transporte_terrestre.via_ruta_a OWNER TO postgres;

--
-- TOC entry 7524 (class 0 OID 0)
-- Dependencies: 410
-- Name: TABLE via_ruta_a; Type: COMMENT; Schema: it_transporte_terrestre; Owner: postgres
--

COMMENT ON TABLE it_transporte_terrestre.via_ruta_a IS 'Trayecto con una superficie especialmente preparada que se mantiene para ser usada por vehículos generalmente a motor. ';


--
-- TOC entry 411 (class 1259 OID 2454433)
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq
    AS integer
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE it_transporte_terrestre.via_ruta_a_gid_seq OWNER TO postgres;

--
-- TOC entry 7525 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE OWNED BY; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER SEQUENCE it_transporte_terrestre.via_ruta_a_gid_seq OWNED BY it_transporte_terrestre.via_ruta_a.gid;


--
-- TOC entry 412 (class 1259 OID 2454434)
-- Name: qgis_projects; Type: TABLE; Schema: proyecto_qgis3; Owner: postgres
--

CREATE TABLE proyecto_qgis3.qgis_projects (
    name text NOT NULL,
    metadata jsonb,
    content bytea
);


ALTER TABLE proyecto_qgis3.qgis_projects OWNER TO postgres;

--
-- TOC entry 413 (class 1259 OID 2454439)
-- Name: acequia_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acequia_l AS
 SELECT acequia_l.gid,
    acequia_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    dit.dit_desc,
    acequia_l.txt,
    (acequia_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM (((ho_aguas_interiores.acequia_l
     JOIN catalogo_objetos.hyp ON ((acequia_l.hyp = hyp.hyp)))
     JOIN catalogo_objetos.dit ON ((acequia_l.dit = dit.dit)))
     JOIN catalogo_objetos.catalogo_objetos ON (((acequia_l.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.acequia_l OWNER TO postgres;

--
-- TOC entry 414 (class 1259 OID 2454444)
-- Name: acera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acera_a AS
 SELECT acera_a.gid,
    acera_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    acera_a.txt,
    (acera_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((it_asociado_transportacion.acera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acera_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((acera_a.smc = smc.smc)));


ALTER TABLE visualizacion.acera_a OWNER TO postgres;

--
-- TOC entry 415 (class 1259 OID 2454449)
-- Name: acueducto_canal_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.acueducto_canal_a AS
 SELECT acueducto_canal_a.gid,
    acueducto_canal_a.fcode,
    catalogo_objetos.descripcion,
    atc.atc_desc,
    smc.smc_desc,
    acueducto_canal_a.txt,
    (acueducto_canal_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((ho_aguas_interiores.acueducto_canal_a
     JOIN catalogo_objetos.catalogo_objetos ON (((acueducto_canal_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.atc ON ((acueducto_canal_a.atc = atc.atc)))
     JOIN catalogo_objetos.smc ON ((acueducto_canal_a.smc = smc.smc)));


ALTER TABLE visualizacion.acueducto_canal_a OWNER TO postgres;

--
-- TOC entry 416 (class 1259 OID 2454454)
-- Name: aeropuerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.aeropuerto_a AS
 SELECT aeropuerto_a.gid,
    aeropuerto_a.fcode,
    catalogo_objetos.descripcion,
    aeropuerto_a.nam,
    acc.acc_desc,
    aeropuerto_a.iko,
    fuc.fuc_desc,
    aeropuerto_a.txt,
    (aeropuerto_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((a_aeropuerto_superficie.aeropuerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((aeropuerto_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((aeropuerto_a.acc = acc.acc)))
     JOIN catalogo_objetos.fuc ON ((aeropuerto_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.aeropuerto_a OWNER TO postgres;

--
-- TOC entry 417 (class 1259 OID 2454459)
-- Name: bordillo_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.bordillo_l AS
 SELECT bordillo_l.gid,
    bordillo_l.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    bordillo_l.txt,
    (bordillo_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM ((it_asociado_transportacion.bordillo_l
     JOIN catalogo_objetos.catalogo_objetos ON (((bordillo_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((bordillo_l.smc = smc.smc)));


ALTER TABLE visualizacion.bordillo_l OWNER TO postgres;

--
-- TOC entry 418 (class 1259 OID 2454464)
-- Name: cancha_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cancha_a AS
 SELECT cancha_a.gid,
    cancha_a.fcode,
    catalogo_objetos.descripcion,
    cancha_a.nam,
    smc.smc_desc,
    kos.kos_desc,
    cancha_a.txt,
    (cancha_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((gs_recreacion.cancha_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cancha_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cancha_a.smc = smc.smc)))
     JOIN catalogo_objetos.kos ON ((cancha_a.kos = kos.kos)));


ALTER TABLE visualizacion.cancha_a OWNER TO postgres;

--
-- TOC entry 419 (class 1259 OID 2454469)
-- Name: cementerio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cementerio_a AS
 SELECT cementerio_a.gid,
    cementerio_a.fcode,
    catalogo_objetos.descripcion,
    cementerio_a.nam,
    rel.rel_desc,
    cementerio_a.txt,
    (cementerio_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((gs_asociado_poblados.cementerio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cementerio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.rel ON ((cementerio_a.rel = rel.rel)));


ALTER TABLE visualizacion.cementerio_a OWNER TO postgres;

--
-- TOC entry 420 (class 1259 OID 2454474)
-- Name: cerca_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cerca_l AS
 SELECT cerca_l.gid,
    cerca_l.fcode,
    catalogo_objetos.descripcion,
    fti.fti_desc,
    wti.wti_desc,
    cerca_l.txt,
    (cerca_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM (((gs_asociado_poblados.cerca_l
     JOIN catalogo_objetos.catalogo_objetos ON (((cerca_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fti ON ((cerca_l.fti = fti.fti)))
     JOIN catalogo_objetos.wti ON ((cerca_l.wti = wti.wti)));


ALTER TABLE visualizacion.cerca_l OWNER TO postgres;

--
-- TOC entry 421 (class 1259 OID 2454479)
-- Name: cuneta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.cuneta_a AS
 SELECT cuneta_a.gid,
    cuneta_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    cuneta_a.txt,
    cuneta_a.the_geom
   FROM ((it_asociado_transportacion.cuneta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((cuneta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((cuneta_a.smc = smc.smc)));


ALTER TABLE visualizacion.cuneta_a OWNER TO postgres;

--
-- TOC entry 422 (class 1259 OID 2454483)
-- Name: edificio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.edificio_a AS
 SELECT edificio_a.gid,
    edificio_a.fcode,
    catalogo_objetos.descripcion,
    edificio_a.nam,
    acc.acc_desc,
    uuc.uuc_desc,
    edificio_a.txt,
    (edificio_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((gs_construcciones.edificio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((edificio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((edificio_a.acc = acc.acc)))
     JOIN catalogo_objetos.uuc ON ((edificio_a.uuc = uuc.uuc)));


ALTER TABLE visualizacion.edificio_a OWNER TO postgres;

--
-- TOC entry 423 (class 1259 OID 2454488)
-- Name: escalinata_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.escalinata_a AS
 SELECT escalinata_a.gid,
    escalinata_a.fcode,
    catalogo_objetos.descripcion,
    smc.smc_desc,
    escalinata_a.txt,
    (escalinata_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((gs_asociado_poblados.escalinata_a
     JOIN catalogo_objetos.catalogo_objetos ON (((escalinata_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((escalinata_a.smc = smc.smc)));


ALTER TABLE visualizacion.escalinata_a OWNER TO postgres;

--
-- TOC entry 424 (class 1259 OID 2454493)
-- Name: estadio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.estadio_a AS
 SELECT estadio_a.gid,
    estadio_a.fcode,
    catalogo_objetos.descripcion,
    estadio_a.nam,
    acc.acc_desc,
    estadio_a.txt,
    (estadio_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((gs_recreacion.estadio_a
     JOIN catalogo_objetos.catalogo_objetos ON (((estadio_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((estadio_a.acc = acc.acc)));


ALTER TABLE visualizacion.estadio_a OWNER TO postgres;

--
-- TOC entry 425 (class 1259 OID 2454498)
-- Name: ferrocarril_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.ferrocarril_a AS
 SELECT ferrocarril_a.gid,
    ferrocarril_a.fcode,
    catalogo_objetos.descripcion,
    ferrocarril_a.nam,
    acc.acc_desc,
    fco.fco_desc,
    loc.loc_desc,
    ferrocarril_a.ltn,
    rgc.rgc_desc,
    rra.rra_desc,
    rrc.rrc_desc,
    ferrocarril_a.txt,
    ferrocarril_a.the_geom
   FROM (((((((it_ferrocarriles.ferrocarril_a
     JOIN catalogo_objetos.catalogo_objetos ON (((ferrocarril_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((ferrocarril_a.acc = acc.acc)))
     JOIN catalogo_objetos.fco ON ((ferrocarril_a.fco = fco.fco)))
     JOIN catalogo_objetos.loc ON ((ferrocarril_a.loc = loc.loc)))
     JOIN catalogo_objetos.rgc ON ((ferrocarril_a.rgc = rgc.rgc)))
     JOIN catalogo_objetos.rra ON ((ferrocarril_a.rra = rra.rra)))
     JOIN catalogo_objetos.rrc ON ((ferrocarril_a.rrc = rrc.rrc)));


ALTER TABLE visualizacion.ferrocarril_a OWNER TO postgres;

--
-- TOC entry 426 (class 1259 OID 2454503)
-- Name: gasolinera_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.gasolinera_a AS
 SELECT gasolinera_a.gid,
    gasolinera_a.fcode,
    catalogo_objetos.descripcion,
    gasolinera_a.nam,
    gasolinera_a.txt,
    (gasolinera_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (it_transporte_terrestre.gasolinera_a
     JOIN catalogo_objetos.catalogo_objetos ON (((gasolinera_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.gasolinera_a OWNER TO postgres;

--
-- TOC entry 427 (class 1259 OID 2454507)
-- Name: granja_acuatica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.granja_acuatica_a AS
 SELECT granja_acuatica_a.gid,
    granja_acuatica_a.fcode,
    catalogo_objetos.descripcion,
    granja_acuatica_a.txt,
    (granja_acuatica_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (ho_regulacion_zonas_restringidas.granja_acuatica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((granja_acuatica_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.granja_acuatica_a OWNER TO postgres;

--
-- TOC entry 428 (class 1259 OID 2454511)
-- Name: intercambiador_vial_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.intercambiador_vial_a AS
 SELECT intercambiador_vial_a.gid,
    intercambiador_vial_a.fcode,
    catalogo_objetos.descripcion,
    intercambiador_vial_a.nam,
    hct.hct_desc,
    rst.rst_desc,
    loc.loc_desc,
    intercambiador_vial_a.txt,
    (intercambiador_vial_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((((it_transporte_terrestre.intercambiador_vial_a
     JOIN catalogo_objetos.catalogo_objetos ON (((intercambiador_vial_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hct ON ((intercambiador_vial_a.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((intercambiador_vial_a.rst = rst.rst)))
     JOIN catalogo_objetos.loc ON ((intercambiador_vial_a.loc = loc.loc)));


ALTER TABLE visualizacion.intercambiador_vial_a OWNER TO postgres;

--
-- TOC entry 429 (class 1259 OID 2454516)
-- Name: invernadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.invernadero_a AS
 SELECT invernadero_a.gid,
    invernadero_a.fcode,
    catalogo_objetos.descripcion,
    invernadero_a.nam,
    invernadero_a.txt,
    (invernadero_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (ii_agropecuaria.invernadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((invernadero_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.invernadero_a OWNER TO postgres;

--
-- TOC entry 430 (class 1259 OID 2454520)
-- Name: isla_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.isla_a AS
 SELECT isla_a.gid,
    isla_a.fcode,
    catalogo_objetos.descripcion,
    isla_a.nam,
    isla_a.na2,
    isla_a.txt,
    (isla_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (ho_zonas_costeras.isla_a
     JOIN catalogo_objetos.catalogo_objetos ON (((isla_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.isla_a OWNER TO postgres;

--
-- TOC entry 431 (class 1259 OID 2454524)
-- Name: lago_laguna_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.lago_laguna_a AS
 SELECT lago_laguna_a.gid,
    lago_laguna_a.fcode,
    catalogo_objetos.descripcion,
    lago_laguna_a.nam,
    lago_laguna_a.na2,
    hyp.hyp_desc,
    lago_laguna_a.txt,
    (lago_laguna_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((ho_aguas_interiores.lago_laguna_a
     JOIN catalogo_objetos.catalogo_objetos ON (((lago_laguna_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((lago_laguna_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.lago_laguna_a OWNER TO postgres;

--
-- TOC entry 432 (class 1259 OID 2454529)
-- Name: muro_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.muro_l AS
 SELECT muro_l.gid,
    muro_l.fcode,
    catalogo_objetos.descripcion,
    wti.wti_desc,
    muro_l.txt,
    (muro_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM ((gs_asociado_poblados.muro_l
     JOIN catalogo_objetos.catalogo_objetos ON (((muro_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wti ON ((muro_l.wti = wti.wti)));


ALTER TABLE visualizacion.muro_l OWNER TO postgres;

--
-- TOC entry 433 (class 1259 OID 2454534)
-- Name: orilla_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.orilla_l AS
 SELECT orilla_l.gid,
    orilla_l.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    slt.slt_desc,
    orilla_l.txt,
    (orilla_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM (((ho_zonas_costeras.orilla_l
     JOIN catalogo_objetos.catalogo_objetos ON (((orilla_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((orilla_l.acc = acc.acc)))
     JOIN catalogo_objetos.slt ON ((orilla_l.slt = slt.slt)));


ALTER TABLE visualizacion.orilla_l OWNER TO postgres;

--
-- TOC entry 434 (class 1259 OID 2454539)
-- Name: parque_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parque_a AS
 SELECT parque_a.gid,
    parque_a.fcode,
    catalogo_objetos.descripcion,
    parque_a.nam,
    fuc.fuc_desc,
    parque_a.txt,
    (parque_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((gs_recreacion.parque_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parque_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.fuc ON ((parque_a.fuc = fuc.fuc)));


ALTER TABLE visualizacion.parque_a OWNER TO postgres;

--
-- TOC entry 435 (class 1259 OID 2454544)
-- Name: parqueadero_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.parqueadero_a AS
 SELECT parqueadero_a.gid,
    parqueadero_a.fcode,
    catalogo_objetos.descripcion,
    parqueadero_a.nam,
    smc.smc_desc,
    parqueadero_a.txt,
    (parqueadero_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((it_asociado_transportacion.parqueadero_a
     JOIN catalogo_objetos.catalogo_objetos ON (((parqueadero_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((parqueadero_a.smc = smc.smc)));


ALTER TABLE visualizacion.parqueadero_a OWNER TO postgres;

--
-- TOC entry 436 (class 1259 OID 2454549)
-- Name: paseo_peatonal_ciclovia_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.paseo_peatonal_ciclovia_a AS
 SELECT paseo_peatonal_ciclovia_a.gid,
    paseo_peatonal_ciclovia_a.fcode,
    catalogo_objetos.descripcion,
    paseo_peatonal_ciclovia_a.nam,
    smc.smc_desc,
    paseo_peatonal_ciclovia_a.txt,
    (paseo_peatonal_ciclovia_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((it_asociado_transportacion.paseo_peatonal_ciclovia_a
     JOIN catalogo_objetos.catalogo_objetos ON (((paseo_peatonal_ciclovia_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((paseo_peatonal_ciclovia_a.smc = smc.smc)));


ALTER TABLE visualizacion.paseo_peatonal_ciclovia_a OWNER TO postgres;

--
-- TOC entry 437 (class 1259 OID 2454554)
-- Name: piscina_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.piscina_a AS
 SELECT piscina_a.gid,
    piscina_a.fcode,
    catalogo_objetos.descripcion,
    piscina_a.nam,
    piscina_a.txt,
    (piscina_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (gs_recreacion.piscina_a
     JOIN catalogo_objetos.catalogo_objetos ON (((piscina_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.piscina_a OWNER TO postgres;

--
-- TOC entry 438 (class 1259 OID 2454558)
-- Name: plaza_publica_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_publica_a AS
 SELECT plaza_publica_a.gid,
    plaza_publica_a.fcode,
    catalogo_objetos.descripcion,
    plaza_publica_a.nam,
    smc.smc_desc,
    plaza_publica_a.txt,
    (plaza_publica_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM ((gs_asociado_poblados.plaza_publica_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_publica_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.smc ON ((plaza_publica_a.smc = smc.smc)));


ALTER TABLE visualizacion.plaza_publica_a OWNER TO postgres;

--
-- TOC entry 439 (class 1259 OID 2454563)
-- Name: plaza_toros_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.plaza_toros_a AS
 SELECT plaza_toros_a.gid,
    plaza_toros_a.fcode,
    catalogo_objetos.descripcion,
    plaza_toros_a.nam,
    plaza_toros_a.txt,
    (plaza_toros_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (gs_recreacion.plaza_toros_a
     JOIN catalogo_objetos.catalogo_objetos ON (((plaza_toros_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.plaza_toros_a OWNER TO postgres;

--
-- TOC entry 440 (class 1259 OID 2454567)
-- Name: puente_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puente_a AS
 SELECT puente_a.gid,
    puente_a.fcode,
    catalogo_objetos.descripcion,
    puente_a.nam,
    puente_a.na2,
    acc.acc_desc,
    bsc.bsc_desc,
    puente_a.ltn,
    typ.typ_desc,
    tuc.tuc_desc,
    puente_a.txt,
    (puente_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((((it_cruces_enlaces.puente_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puente_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((puente_a.acc = acc.acc)))
     JOIN catalogo_objetos.bsc ON ((puente_a.bsc = bsc.bsc)))
     JOIN catalogo_objetos.typ ON ((puente_a.typ = typ.typ)))
     JOIN catalogo_objetos.tuc ON ((puente_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.puente_a OWNER TO postgres;

--
-- TOC entry 441 (class 1259 OID 2454572)
-- Name: puerto_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.puerto_a AS
 SELECT puerto_a.gid,
    puerto_a.fcode,
    catalogo_objetos.descripcion,
    puerto_a.nam,
    puerto_a.txt,
    (puerto_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (ho_puertos_muelles.puerto_a
     JOIN catalogo_objetos.catalogo_objetos ON (((puerto_a.fcode)::text = (catalogo_objetos.fcode)::text)));


ALTER TABLE visualizacion.puerto_a OWNER TO postgres;

--
-- TOC entry 442 (class 1259 OID 2454576)
-- Name: punto_control_p; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.punto_control_p AS
 SELECT punto_control_p.gid,
    punto_control_p.fcode,
    catalogo_objetos.descripcion,
    acc.acc_desc,
    ela.ela_desc,
    punto_control_p.zvh,
    punto_control_p.txt,
    (punto_control_p.the_geom)::public.geometry(Point,32717) AS the_geom
   FROM (((d_linderos_propiedad.punto_control_p
     JOIN catalogo_objetos.catalogo_objetos ON (((punto_control_p.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((punto_control_p.acc = acc.acc)))
     JOIN catalogo_objetos.ela ON ((punto_control_p.ela = ela.ela)));


ALTER TABLE visualizacion.punto_control_p OWNER TO postgres;

--
-- TOC entry 443 (class 1259 OID 2454581)
-- Name: rio_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_a AS
 SELECT rio_a.gid,
    rio_a.fcode,
    catalogo_objetos.descripcion,
    rio_a.nam,
    rio_a.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_a.txt,
    (rio_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_a ON (((catalogo_objetos.fcode)::text = (rio_a.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_a.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_a.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_a OWNER TO postgres;

--
-- TOC entry 444 (class 1259 OID 2454586)
-- Name: rio_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rio_l AS
 SELECT rio_l.gid,
    rio_l.fcode,
    catalogo_objetos.descripcion,
    rio_l.nam,
    rio_l.na2,
    acc.acc_desc,
    hyp.hyp_desc,
    rio_l.txt,
    (rio_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM (((catalogo_objetos.catalogo_objetos
     JOIN ho_aguas_interiores.rio_l ON (((catalogo_objetos.fcode)::text = (rio_l.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((rio_l.acc = acc.acc)))
     JOIN catalogo_objetos.hyp ON ((rio_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.rio_l OWNER TO postgres;

--
-- TOC entry 445 (class 1259 OID 2454591)
-- Name: rodera_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.rodera_l AS
 SELECT rodera_l.gid,
    rodera_l.fcode,
    catalogo_objetos.descripcion,
    typ.typ_desc,
    rst.rst_desc,
    hct.hct_desc,
    rdt.rdt_desc,
    wtc.wtc_desc,
    rodera_l.ltn,
    tuc.tuc_desc,
    rodera_l.txt,
    (rodera_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM (((((((it_transporte_terrestre.rodera_l
     JOIN catalogo_objetos.catalogo_objetos ON (((rodera_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.typ ON ((rodera_l.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((rodera_l.hct = hct.hct)))
     JOIN catalogo_objetos.rst ON ((rodera_l.rst = rst.rst)))
     JOIN catalogo_objetos.rdt ON ((rodera_l.rdt = rdt.rdt)))
     JOIN catalogo_objetos.wtc ON ((rodera_l.wtc = wtc.wtc)))
     JOIN catalogo_objetos.tuc ON ((rodera_l.tuc = tuc.tuc)));


ALTER TABLE visualizacion.rodera_l OWNER TO postgres;

--
-- TOC entry 446 (class 1259 OID 2454596)
-- Name: sendero_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.sendero_l AS
 SELECT sendero_l.gid,
    sendero_l.fcode,
    catalogo_objetos.descripcion,
    wtc.wtc_desc,
    sendero_l.txt,
    (sendero_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM ((it_transporte_terrestre.sendero_l
     JOIN catalogo_objetos.catalogo_objetos ON (((sendero_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.wtc ON ((sendero_l.wtc = wtc.wtc)));


ALTER TABLE visualizacion.sendero_l OWNER TO postgres;

--
-- TOC entry 447 (class 1259 OID 2454601)
-- Name: tunel_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.tunel_a AS
 SELECT tunel_a.gid,
    tunel_a.fcode,
    catalogo_objetos.descripcion,
    tunel_a.nam,
    tra.tra_desc,
    tuc.tuc_desc,
    tunel_a.txt,
    tunel_a.the_geom
   FROM (((it_asociado_transportacion.tunel_a
     JOIN catalogo_objetos.catalogo_objetos ON (((tunel_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.tra ON ((tunel_a.tra = tra.tra)))
     JOIN catalogo_objetos.tuc ON ((tunel_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.tunel_a OWNER TO postgres;

--
-- TOC entry 448 (class 1259 OID 2454606)
-- Name: via_ruta_a; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.via_ruta_a AS
 SELECT via_ruta_a.gid,
    via_ruta_a.fcode,
    catalogo_objetos.descripcion,
    via_ruta_a.nam,
    via_ruta_a.na2,
    acc.acc_desc,
    rst.rst_desc,
    typ.typ_desc,
    hct.hct_desc,
    loc.loc_desc,
    via_ruta_a.ltn,
    mes.mes_desc,
    rdt.rdt_desc,
    tuc.tuc_desc,
    via_ruta_a.txt,
    (via_ruta_a.the_geom)::public.geometry(MultiPolygon,32717) AS the_geom
   FROM (((((((((it_transporte_terrestre.via_ruta_a
     JOIN catalogo_objetos.catalogo_objetos ON (((via_ruta_a.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.acc ON ((via_ruta_a.acc = acc.acc)))
     JOIN catalogo_objetos.rst ON ((via_ruta_a.rst = rst.rst)))
     JOIN catalogo_objetos.typ ON ((via_ruta_a.typ = typ.typ)))
     JOIN catalogo_objetos.hct ON ((via_ruta_a.hct = hct.hct)))
     JOIN catalogo_objetos.loc ON ((via_ruta_a.loc = loc.loc)))
     JOIN catalogo_objetos.mes ON ((via_ruta_a.mes = mes.mes)))
     JOIN catalogo_objetos.rdt ON ((via_ruta_a.rdt = rdt.rdt)))
     JOIN catalogo_objetos.tuc ON ((via_ruta_a.tuc = tuc.tuc)));


ALTER TABLE visualizacion.via_ruta_a OWNER TO postgres;

--
-- TOC entry 449 (class 1259 OID 2454611)
-- Name: zanja_l; Type: VIEW; Schema: visualizacion; Owner: postgres
--

CREATE VIEW visualizacion.zanja_l AS
 SELECT zanja_l.gid,
    zanja_l.fcode,
    catalogo_objetos.descripcion,
    hyp.hyp_desc,
    zanja_l.txt,
    (zanja_l.the_geom)::public.geometry(LineString,32717) AS the_geom
   FROM ((ho_aguas_interiores.zanja_l
     JOIN catalogo_objetos.catalogo_objetos ON (((zanja_l.fcode)::text = (catalogo_objetos.fcode)::text)))
     JOIN catalogo_objetos.hyp ON ((zanja_l.hyp = hyp.hyp)));


ALTER TABLE visualizacion.zanja_l OWNER TO postgres;

--
-- TOC entry 6464 (class 2604 OID 2454616)
-- Name: aeropuerto_a gid; Type: DEFAULT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a ALTER COLUMN gid SET DEFAULT nextval('a_aeropuerto_superficie.aeropuerto_a_gid_seq'::regclass);


--
-- TOC entry 6470 (class 2604 OID 2454617)
-- Name: catalogo_objetos gid; Type: DEFAULT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos ALTER COLUMN gid SET DEFAULT nextval('catalogo_objetos.catalogo_objetos_gid_seq'::regclass);


--
-- TOC entry 6472 (class 2604 OID 2454618)
-- Name: punto_control_p gid; Type: DEFAULT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p ALTER COLUMN gid SET DEFAULT nextval('d_linderos_propiedad.vertice_geodesico_p_gid_seq'::regclass);


--
-- TOC entry 6479 (class 2604 OID 2454619)
-- Name: cementerio_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cementerio_a_gid_seq'::regclass);


--
-- TOC entry 6486 (class 2604 OID 2454620)
-- Name: cerca_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.cerca_l_gid_seq'::regclass);


--
-- TOC entry 6493 (class 2604 OID 2454621)
-- Name: escalinata_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.escalinata_a_gid_seq'::regclass);


--
-- TOC entry 6500 (class 2604 OID 2454622)
-- Name: muro_l gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.muro_l_gid_seq'::regclass);


--
-- TOC entry 6507 (class 2604 OID 2454623)
-- Name: plaza_publica_a gid; Type: DEFAULT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a ALTER COLUMN gid SET DEFAULT nextval('gs_asociado_poblados.plaza_publica_a_gid_seq'::regclass);


--
-- TOC entry 6514 (class 2604 OID 2454624)
-- Name: edificio_a gid; Type: DEFAULT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a ALTER COLUMN gid SET DEFAULT nextval('gs_construcciones.edificio_a_gid_seq'::regclass);


--
-- TOC entry 6521 (class 2604 OID 2454625)
-- Name: cancha_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.cancha_a_gid_seq'::regclass);


--
-- TOC entry 6528 (class 2604 OID 2454626)
-- Name: estadio_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.estadio_a_gid_seq'::regclass);


--
-- TOC entry 6535 (class 2604 OID 2454627)
-- Name: parque_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.parque_a_gid_seq'::regclass);


--
-- TOC entry 6542 (class 2604 OID 2454628)
-- Name: piscina_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.piscina_a_gid_seq'::regclass);


--
-- TOC entry 6549 (class 2604 OID 2454629)
-- Name: plaza_toros_a gid; Type: DEFAULT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a ALTER COLUMN gid SET DEFAULT nextval('gs_recreacion.plaza_toros_a_gid_seq'::regclass);


--
-- TOC entry 6556 (class 2604 OID 2454630)
-- Name: acequia_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acequia_l_gid_seq'::regclass);


--
-- TOC entry 6563 (class 2604 OID 2454631)
-- Name: acueducto_canal_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.acueducto_canal_a_gid_seq'::regclass);


--
-- TOC entry 6570 (class 2604 OID 2454632)
-- Name: lago_laguna_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.lago_laguna_a_gid_seq'::regclass);


--
-- TOC entry 6577 (class 2604 OID 2454633)
-- Name: rio_a gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_a_gid_seq'::regclass);


--
-- TOC entry 6584 (class 2604 OID 2454634)
-- Name: rio_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.rio_l_gid_seq'::regclass);


--
-- TOC entry 6591 (class 2604 OID 2454635)
-- Name: zanja_l gid; Type: DEFAULT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l ALTER COLUMN gid SET DEFAULT nextval('ho_aguas_interiores.zanja_l_gid_seq'::regclass);


--
-- TOC entry 6598 (class 2604 OID 2454636)
-- Name: puerto_a gid; Type: DEFAULT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a ALTER COLUMN gid SET DEFAULT nextval('ho_puertos_muelles.puerto_a_gid_seq'::regclass);


--
-- TOC entry 6605 (class 2604 OID 2454637)
-- Name: granja_acuatica_a gid; Type: DEFAULT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a ALTER COLUMN gid SET DEFAULT nextval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq'::regclass);


--
-- TOC entry 6612 (class 2604 OID 2454638)
-- Name: isla_a gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.isla_a_gid_seq'::regclass);


--
-- TOC entry 6619 (class 2604 OID 2454639)
-- Name: orilla_l gid; Type: DEFAULT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l ALTER COLUMN gid SET DEFAULT nextval('ho_zonas_costeras.orilla_l_gid_seq'::regclass);


--
-- TOC entry 6633 (class 2604 OID 2454640)
-- Name: acera_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.acera_a_gid_seq'::regclass);


--
-- TOC entry 6640 (class 2604 OID 2454641)
-- Name: bordillo_l gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.bordillo_l_gid_seq'::regclass);


--
-- TOC entry 6647 (class 2604 OID 2454642)
-- Name: cuneta_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.cuneta_a_gid_seq'::regclass);


--
-- TOC entry 6654 (class 2604 OID 2454643)
-- Name: parqueadero_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.parqueadero_a_gid_seq'::regclass);


--
-- TOC entry 6661 (class 2604 OID 2454644)
-- Name: paseo_peatonal_ciclovia_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq'::regclass);


--
-- TOC entry 6668 (class 2604 OID 2454645)
-- Name: tunel_a gid; Type: DEFAULT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a ALTER COLUMN gid SET DEFAULT nextval('it_asociado_transportacion.tunel_a_gid_seq'::regclass);


--
-- TOC entry 6675 (class 2604 OID 2454646)
-- Name: puente_a gid; Type: DEFAULT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a ALTER COLUMN gid SET DEFAULT nextval('it_cruces_enlaces.puente_a_gid_seq'::regclass);


--
-- TOC entry 6682 (class 2604 OID 2454647)
-- Name: ferrocarril_a gid; Type: DEFAULT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a ALTER COLUMN gid SET DEFAULT nextval('it_ferrocarriles.ferrocarril_a_gid_seq'::regclass);


--
-- TOC entry 6689 (class 2604 OID 2454648)
-- Name: gasolinera_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.gasolinera_a_gid_seq'::regclass);


--
-- TOC entry 6696 (class 2604 OID 2454649)
-- Name: intercambiador_vial_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.intercambiador_vial_a_gid_seq'::regclass);


--
-- TOC entry 6703 (class 2604 OID 2454650)
-- Name: rodera_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.rodera_l_gid_seq'::regclass);


--
-- TOC entry 6710 (class 2604 OID 2454651)
-- Name: sendero_l gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.sendero_l_gid_seq'::regclass);


--
-- TOC entry 6717 (class 2604 OID 2454652)
-- Name: via_ruta_a gid; Type: DEFAULT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a ALTER COLUMN gid SET DEFAULT nextval('it_transporte_terrestre.via_ruta_a_gid_seq'::regclass);


--
-- TOC entry 7334 (class 0 OID 2453904)
-- Dependencies: 309
-- Data for Name: aeropuerto_a; Type: TABLE DATA; Schema: a_aeropuerto_superficie; Owner: postgres
--



--
-- TOC entry 7336 (class 0 OID 2453916)
-- Dependencies: 311
-- Data for Name: acc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.acc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.acc VALUES (1, '1.- Exacta');
INSERT INTO catalogo_objetos.acc VALUES (2, '2.- Aproximada');
INSERT INTO catalogo_objetos.acc VALUES (3, '3.- Dudosa');
INSERT INTO catalogo_objetos.acc VALUES (7, '7.- Precisa');
INSERT INTO catalogo_objetos.acc VALUES (998, '998.- No aplica');


--
-- TOC entry 7337 (class 0 OID 2453919)
-- Dependencies: 312
-- Data for Name: atc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.atc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.atc VALUES (1, '1.- Pozo Qanat');
INSERT INTO catalogo_objetos.atc VALUES (3, '3.- Acueducto subterráneo');
INSERT INTO catalogo_objetos.atc VALUES (4, '4.- Bajo el agua');
INSERT INTO catalogo_objetos.atc VALUES (5, '5.- Superficie');
INSERT INTO catalogo_objetos.atc VALUES (998, '998.- No aplica');


--
-- TOC entry 7338 (class 0 OID 2453922)
-- Dependencies: 313
-- Data for Name: bsc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.bsc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.bsc VALUES (1, '1.- Arco abierto Spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (2, '2.- Voladizo');
INSERT INTO catalogo_objetos.bsc VALUES (3, '3.- Cubierta');
INSERT INTO catalogo_objetos.bsc VALUES (5, '5.- Flotante');
INSERT INTO catalogo_objetos.bsc VALUES (6, '6.- De viga');
INSERT INTO catalogo_objetos.bsc VALUES (7, '7.- Torre de suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (8, '8.- Entramado');
INSERT INTO catalogo_objetos.bsc VALUES (9, '9.- Suspensión');
INSERT INTO catalogo_objetos.bsc VALUES (12, '12.- Transportador');
INSERT INTO catalogo_objetos.bsc VALUES (15, '15.- De losa');
INSERT INTO catalogo_objetos.bsc VALUES (16, '16.- Viga y largero');
INSERT INTO catalogo_objetos.bsc VALUES (19, '19.- Cuerda del arco del puente');
INSERT INTO catalogo_objetos.bsc VALUES (22, '22.- Cubierto');
INSERT INTO catalogo_objetos.bsc VALUES (26, '26.- Arco cerrado spandrel');
INSERT INTO catalogo_objetos.bsc VALUES (27, '27.- Atirantado');
INSERT INTO catalogo_objetos.bsc VALUES (28, '28.- Viaducto');
INSERT INTO catalogo_objetos.bsc VALUES (31, '31.- Arco');
INSERT INTO catalogo_objetos.bsc VALUES (32, '32.- Caballete');
INSERT INTO catalogo_objetos.bsc VALUES (998, '998.- No aplica');


--
-- TOC entry 7339 (class 0 OID 2453925)
-- Dependencies: 314
-- Data for Name: catalogo_objetos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA051', 'Boca de Pozo', 'Equipo utilizado para mantener el control de un pozo, incluyen accesorios como válvulas.', 1);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA052', 'Campo de Petróleo/Gas', 'Área donde se ha identificado la presencia de petróleo, aceite y/o gas natural.', 2);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA012', 'Cantera', 'Explotación generalmente a cielo abierto de la que se obtienen rocas industriales, ornamentales y otros materiales usados en la construcción.', 3);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA010', 'Mina', 'Excavación hecha en la tierra para la extracción de materiales de depósitos naturales.', 4);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA050', 'Pozo', 'Excavación o perforación hecha en la tierra o mar para la extracción de líquidos o gases.', 5);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AA040', 'Torre de Perforación', 'Superestructura equipada para la perforación o el levantamiento de las operaciones de extracción y / o explotación de recursos naturales.', 6);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB241', 'Astillero', 'Área  al lado del mar o un río importante, que incluye  instalaciones en las que los buques se construyen o reparan.', 7);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC040', 'Instalación Petrolera', 'Área con instalaciones para la producción o distribución de petróleo, aceite y/o productos de gas natural.', 8);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC000', 'Planta de Procesamiento', 'Instalación que incluye uno o más edificios utilizados para procesar materiales.', 9);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH220', 'Planta de Tratamiento de Agua', 'Instalaciones para el almacenamiento, purificación y suministro del agua para un área o una ciudad.', 10);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AE010', 'Planta Ensambladora', 'Edificio o grupo de edificios dedicados a combinar piezas fabricadas para obtener un producto terminado.', 11);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AC030', 'Tanque de Decantación', 'Sitio donde la materia sólida se precipita de un líquido mediante sedimentación.', 12);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH175', 'Abrevadero', 'Contenedor abierto de retención de agua para dar de beber a los animales.', 13);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ030', 'Corral', 'Lugar cerrado en el cual el ganado es custodiado temporalmente.', 14);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ080', 'Establo', 'Lugar cubierto adaptado para el refugio y alimentación del ganado y las aves.', 15);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ060', 'Hacienda', 'Lugar que puede ser de cualquier tamaño desde unas pocas hectáreas a miles de hectáreas, y puede estar especializada en una particular forma de producción de alimento y/o ganado.', 16);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ070', 'Rancho', 'Extensión de tierra, incluye las estructuras, cuyo principal uso es el pastoreo de ganado en general, puede presentar también cultivos.', 17);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH240', 'Sistema de Irrigación', 'Sistema para proveer de agua a la tierra, generalmente a través de una red de canales o tuberías.', 18);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD010', 'Central Eléctrica', 'Edificio y equipamiento necesario para la generación de energía eléctrica.', 19);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT030', 'Línea de Transmisión Eléctrica', 'Cable que transmite o distribuye energía eléctrica.', 20);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AD030', 'Subestación Eléctrica', 'Infraestructura localizada sobre la ruta de la línea de energía eléctrica en la cual se transforma  y/o se distribuye la energía.', 21);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT010', 'Antena Parabólica', 'Objeto cóncavo utilizado para la transmisión o recepción de señales electromagnéticas.', 22);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT060', 'Línea Telefónica', 'Sistema de comunicación que transmite señales eléctricas con información a distancias muy largas.', 23);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT080', 'Torre de Comunicación', 'Estructura relativamente alta utilizada para transmitir, y/o recibir señales de comunicación electromagnéticas.', 24);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF010', 'Chimenea', 'Estructura vertical que contiene un tubo o cañón para descarga de humo o gases de combustión.', 25);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF070', 'Mechero', 'Tubería abierta en la cual los gases residuales son quemados.', 26);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AF030', 'Torre de Enfriamiento', 'Torre utilizada para enfriar líquidos.', 27);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ113', 'Tubería', 'Serie de tubos conectados para el transporte de sólidos, líquidos o gases.', 28);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM010', 'Bodega', 'Área utilizada para almacenamiento de productos o suministros.', 29);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM040', 'Pila Mineral', 'Montículo de productos mineros o de cantera, extraídos por el hombre, que no contienen materiales de desecho.', 30);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM091', 'Silo', 'Contenedor cilíndrico cerrado, utilizado para guardar el grano o forraje.', 31);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM070', 'Tanque de Almacenamiento', 'Depósito usado para el almacenamiento de líquidos y/o gases.', 32);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM080', 'Torre de Agua', 'Torre que sirve de apoyo a un tanque elevado de almacenamiento de agua.', 33);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB021', 'Difusor/Colector', 'Instalación artificial, generalmente subterránea donde los líquidos son evacuados.', 34);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB030', 'Instalación para Procesamiento de Residuos', 'Sitio funcional con edificios y otras instalaciones, donde los residuos son procesados a través de  procedimientos químicos, físicos, biológicos o térmicos, o combinaciones de estos.', 35);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AB000', 'Vertedero/Basurero', 'Área para la recolección o depósito de materiales de desecho o descarga.', 36);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL135', 'Comunidad', 'Concentración de viviendas nativas, generalmente chozas, usualmente de construcción tradicional.', 37);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL015', 'Edificio', 'Estructura techada relativamente permanente, diseñada para algún uso particular.', 38);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL105', 'Poblado', 'Concentración continua ocupada de tiendas  o ligeras estructuras fijas (por ejemplo: chozas) que sirven como residencia.', 39);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL020', 'Zona Edificada', 'Área que contiene concentración de construcciones y/u otras estructuras.', 40);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL030', 'Cementerio', 'Sitio de estructuras asociadas, utilizadas para el entierro de muertos.', 41);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL070', 'Cerca', 'Barrera artificial construida por el hombre de estructura relativamente liviana utilizada como cercado o límite.', 42);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL099', 'Choza', 'Construcción rústica, pequeña, sencilla e independiente que por lo general tiene una sola habitación individual multifunción.', 43);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ150', 'Escalinata', 'Serie de escalones que sirven para subir a un plano más elevado o para bajar a un plano inferior.', 44);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL130', 'Monumento', 'Estructura levantada o mantenida en memoria a una persona o evento.', 45);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL260', 'Muro', 'Barrera hecha por el hombre de material resistente utilizado como límite o para protección.', 46);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL170', 'Plaza Pública', 'Sitio abierto y que sirve como lugar de reunión pública en una zona poblada para diversos usos.', 47);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH230', 'Pozo de Agua', 'Excavación o perforación hecha en la tierra para la extracción de agua.', 48);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL241', 'Torre', 'Estructura relativamente alta,  que puede presentarse sola o puede formar parte de otra estructura.', 49);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL240', 'Torre que no es para Comunicación', 'Torre  que se utiliza para fines distintos de la comunicación.', 50);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AG030', 'Complejo Comercial', 'Instalaciones comerciales de varios  almacenes, con restaurantes, lugares de entretenimiento y  otras empresas,  está completamente cubierto y cuenta con una amplia zona de estacionamiento.', 51);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA011', 'Línea de Costa', 'Línea generada por el contacto entre la tierra y un cuerpo de agua afectado por mareas y definida por el nivel de la pleamar media.', 98);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL014', 'Estructura no Construida', 'Construcción económicamente independiente,  diseñada para apoyar las actividades humanas (por ejemplo:  agricultura,  industria o minería), pero no destinados a la ocupación humana y/o habitación.', 52);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL011', 'Instalación', 'Agrupación de instalaciones, situadas en la misma zona, que apoyan funciones particulares.', 53);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK200', 'Balneario', 'Establecimiento que se levanta cerca de fuentes de aguas mineromedicinales (declaradas de utilidad pública) con la finalidad de utilizar sus propiedades terapéuticas y estéticas.', 54);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK040', 'Cancha', 'Lugar al aire libre destinado a eventos deportivos, ejercicio o juegos.', 55);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK160', 'Coliseo', 'Escenario parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores de pie o sentados visualizar un evento.  A menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: fútbol, ​​baloncesto, etc.), teatro o actuaciones musicales.', 56);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK165', 'Estadio', 'Campo deportivo parcial o totalmente rodeado por una estructura diseñada para permitir a los espectadores ver un evento de pie o sentados; a menudo diseñados en forma y tamaño para dar cabida a deportes específicos (por ejemplo: el fútbol).', 57);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK121', 'Mirador', 'Área, generalmente en un lugar elevado, con infraestructura para observaciones del paisaje circundante.', 58);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK120', 'Parque', 'Área utilizada con propósitos recreacionales u ornamentales.', 59);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK030', 'Parque de Diversión', 'Instalación predominantemente artificial, equipada con dispositivos recreacionales.', 60);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK190', 'Paseo Marítimo', 'Estructura que se extiende en el agua utilizada con propósitos recreacionales, no pretende ser un lugar de atraque de buques.', 61);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK170', 'Piscina', 'Construcción destinada a contener agua con fines de recreación y natación.', 62);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK130', 'Pista de Carreras', 'Superficie que se utiliza para competencias de carreras.', 63);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK166', 'Plaza de Toros', 'Construcción generalmente circular u ovalada, de cielo abierto, rodeada por graderíos para los espectadores.', 64);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK090', 'Recinto Ferial', 'Área donde existen instalaciones permanentes al aire libre para realizar ferias, circos o exhibiciones.', 65);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL200', 'Ruinas', 'Remanentes deteriorados de estructuras no especificadas.', 66);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL012', 'Sitio Arqueológico', 'Sitio donde se ha descubierto la existencia de restos de civilizaciones ancestrales o actividades humanas.', 67);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL201', 'Sitio Histórico', 'Sitio o área declarada de significado histórico nacional o provincial mantenido para el público.', 68);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK110', 'Tribuna', 'Estructura elevada en vías, centros deportivos, etc. generalmente para la presentación especial de eventos al aire libre.', 69);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AK180', 'Zoológico', 'Lugar donde los animales, generalmente salvajes, se mantienen en exposición al público, pueden reproducirse y ser estudiados.', 70);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL142', 'Observatorio Astronómico', 'Edificio diseñado y equipado para realizar observaciones de objetos celestes, del espacio y del universo en su conjunto.', 71);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN010', 'Ferrocarril', 'Una o más vías de ferrocarril que comprende una red utilizada para el transporte de pasajeros y/o bienes.', 72);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AN070', 'Estación de Ferrocarril', 'Instalación en la que los pasajeros pueden subir y bajar de los trenes y/o cargar  y descargar  mercancías del transporte ferroviario.', 73);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ180', 'Estación de Pesaje', 'Construcción y equipos asociados que se utilizan para examinar y pesar  los vehículos de motor.', 74);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ170', 'Gasolinera', 'Establecimiento en el cual se vende combustible y lubricantes generalmente para vehículos de motor.', 75);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP020', 'Intercambiador Vial', 'Conexión diseñada para facilitar el acceso del tráfico de una carretera a  otra.', 76);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP010', 'Rodera', 'Vía natural con poca o ninguna mejora por la que pueden transitar vehículos de doble tracción.', 77);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP050', 'Sendero', 'Camino angosto abierto por el tránsito de personas o animales.', 78);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP030', 'Vía o Ruta', 'Trayecto con una superficie especialmente  preparada que se mantiene para ser usada por vehículos generalmente a motor.', 79);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT041', 'Transporte Aéreo por Cable', 'Sistema de transporte que consiste en cables de carga  unidos entre torres en los que están suspendidas las unidades (por ejemplo: tarabita, teleférico).', 80);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ070', 'Gabarra', 'Ruta definida que cruza una gabarra de una orilla a otra.', 81);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ040', 'Puente', 'Estructura que conecta dos lugares y facilita el paso  de una ruta de  transporte (por ejemplo:carretera o ferrocarril)  sobre un obstáculo del terreno (por ejemplo: cuerpo de agua, barranco y/o carretera).', 82);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ065', 'Alcantarilla', 'Estructura hecha por el hombre que permite el cruce de un cauce de agua bajo una vía u otra infraestructura, así como una construcción destinada a evacuar aguas residuales.', 83);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP040', 'Control Vehicular', 'Barrera en una ruta de transporte (por ejemplo: una carretera, un ferrocarril, un túnel o un puente) que controla el paso (puede ser abierto o cerrado).', 84);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ036', 'Cuneta', 'Borde de hormigón, asfalto o piedras que forman parte de un canal a lo largo del borde de una calle o carretera.', 85);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ080', 'Estación de Gabarra', 'Lugar donde una gabarra toma o descarga su carga.', 86);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM510', 'Estación de Transbordo', 'Complejo de edificios, instalaciones asociadas, carreteras y zonas adaptadas, utilizadas para el transbordo de pasajeros y carga entre los mismos o diferentes tipos de transporte.', 87);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ125', 'Estación de Transporte', 'Estación que sirve como un punto de parada a lo largo de una ruta de transporte.', 88);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ140', 'Parqueadero', 'Lugar destinado generalmente para estacionar vehículos.', 89);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP034', 'Parterre', 'Obra o espacio vial entre dos rutas de transporte para separar el flujo del tráfico (por ejemplo, en sentido contrario).', 90);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AP031', 'Paseo Peatonal / Ciclovía', 'Franja de terreno pavimentada o mejorada que tiene por objeto servir como una vía para  peatones, animales y/o vehículos no motorizado.', 91);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ152', 'Puente Peatonal', 'Estructura elevada o suspendida que permite el  paso de peatones.', 92);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ060', 'Torre de Control', 'Estructura que alberga personas y equipos que cumplen con  la función de controlar el tráfico aéreo, náutico o de trenes.', 93);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ130', 'Túnel', 'Paso subterráneo o submarino, abierto para establecer comunicación.', 94);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH190', 'Albufera', 'Laguna natural que se forma en una bahía o entrada de mar cuya boca ha quedado cerrada por cordones de arena o arrecifes de coral.', 95);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA023', 'Anteplaya', 'La parte de la costa o playa que se encuentra entre la línea de bajamar y el límite superior de la acción del oleaje normal (arena, grava, arcilla y barro).', 96);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA030', 'Isla', 'Masa de tierra más pequeña que un continente y rodeada por agua.', 97);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA040', 'Mar', 'Masa de agua salada que cubre la mayor parte de la superficie de la Tierra.', 99);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA010', 'Orilla', 'Línea donde una superficie está en contacto con un cuerpo de agua.', 100);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA050', 'Playa', 'Ribera del mar o de un río grande, formada de arenales en un superficie casi plana.', 101);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BA051', 'Dique', 'Barrera o construcción para contener o detener el agua.', 102);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI030', 'Esclusa', 'Un par o una serie de compuertas utilizadas para levantar y bajar los barcos a medida que pasan desde el nivel del agua a otra.', 103);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB043', 'Malecón', 'Murallón que corre paralelo a la orilla del mar o de un río, con la finalidad de proteger de las aguas.', 104);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB190', 'Muelle', 'Obra construida en un puerto de mar o en la orilla de un río navegable para facilitar las tareas de carga, descarga y para atracar los barcos.', 105);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB005', 'Puerto', 'Conjunto de obras, instalaciones y servicios que proporcionan el espacio necesario para la estancia de los buques mientras realizan operaciones de carga, descarga, almacenaje y tránsito de viajeros.', 106);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BB041', 'Rompeolas', 'Estructura avanzada hacia el mar que protege un puerto o playa de la acción de las olas.', 107);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BE015', 'Curva Batimétrica', 'Línea que conecta puntos de igual profundidad y por debajo del datum hidrográfico.', 108);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC020', 'Boya', 'Objeto flotante que se sujeta al fondo del mar, de un lago o de un río, que sirve como ayuda a la navegación.', 109);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BC050', 'Faro', 'Estructura distintiva dentro o fuera de la costa con luz en su parte superior, diseñado para servir como una ayuda a la navegación.', 110);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD120', 'Arrecife', 'Costa peñascosa, formada en el mar por roca o coral, casi a flor de agua, que constituye peligro para la navegación.', 111);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD180', 'Naufragio', 'Ruinas de un barco hundido o irreversiblemente dañado.', 112);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD110', 'Plataforma marina', 'Superficie plana levantada sobre el mar, como etapa de trabajo en la conducción de operaciones mar adentro.', 113);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD130', 'Roca', 'Formación rocosa aislada, piedra o coral de gran tamaño, que constituye un peligro para la navegación.', 114);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH050', 'Granja Acuática', 'Área cerrada de agua utilizada para la reproducción o cría de camarones, peces y similares.', 115);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH030', 'Acequia', 'Excavación poco profunda construida en tierra con propósitos de drenaje o irrigación.', 116);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH010', 'Acueducto o Canal', 'Cauce artificial que transporta agua en forma de flujo continuo desde un lugar en el que ésta es accesible para consumo u otros usos.', 117);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH090', 'Área de Inundación', 'Área periódicamente cubierta por agua, excluyendo el agua por marea.', 118);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH011', 'Bocatoma', 'Lugar donde el agua es captada en un canal, tubería u otro cuerpo de agua.', 119);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH020', 'Canal de Navegación', 'Canal artificial sin flujo o flujo controlado, construido o usado para navegación.', 120);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH200', 'Característica Miscelánea de Drenaje de Superficie', 'Característica de drenaje de superficie la cual es de naturaleza menor y que no está incluida en otros elementos codificado en estas especificaciones.', 121);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH180', 'Cascada', 'Caída vertical de un curso de agua, producida por brusco desnivel del cauce.', 122);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH015', 'Ciénaga', 'Área permanentemente húmeda de la tierra formada por materia orgánica en descomposición y sobre todo de agua dulce estancada.', 123);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI010', 'Cisterna', 'Contenedor cubierto, construido por el hombre utilizado para recolectar y almacenar el agua.', 124);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI040', 'Compuerta', 'Puerta utilizada para regular el flujo de agua.', 125);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH130', 'Embalse', 'Depósito artificial en el que se almacenan las aguas de un río o un arroyo, generalmente mediante una presa o un dique que cierra la boca de un valle.', 126);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ116', 'Estación de Bombeo', 'Instalación para mover sólidos, líquidos o gases a través de presión o succión.', 127);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH081', 'Estanque', 'Depósito construido para recolección o almacenamiento de agua para consumo humano o agropecuario.', 128);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH155', 'Evaporador Salino', 'Piscina poco profunda, normalmente construida por el hombre, en donde se recoge sal por la evaporación natural del agua.', 129);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH080', 'Lago o Laguna', 'Cuerpo de agua, dulce o salada, rodeada por tierra.', 130);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH170', 'Manantial', 'Flujo natural de agua que brota en la superficie de la tierra.', 131);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BI020', 'Presa', 'Estructura generalmente de cemento armado, construida a través de un río, arroyo o canal  para contener o controlar el caudal.', 132);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH145', 'Punto Desvanecido', 'Lugar en el cual la corriente de agua desaparece o se desvanece en el terreno.', 133);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH120', 'Rápidos', 'Partes de un río, donde la corriente fluye con gran rapidez, debido a alteraciones en la superficie provocadas por obstrucciones tale como rocas y peñascos.', 134);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH140', 'Río', 'Curso de agua que fluye naturalmente.', 135);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ020', 'Sifón', 'Tubería utilizada para el transporte de líquidos de un nivel  a un nivel inferior, usando la diferencia de presión del líquido para forzar subir a la columna hasta un nivel más alto antes de que caiga a la salida.', 136);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH070', 'Vado', 'Sitio poco profundo en un río o corriente de agua utilizado para cruzar a pie, a caballo o en vehículo.', 137);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH100', 'Zanja', 'Excavación larga y estrecha que se hace en la tierra para echar los cimientos, conducir las aguas, defender los sembríos o usos semejantes.', 138);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA010', 'Curva de Nivel', 'Línea que conecta puntos que tienen el mismo valor de altura respecto al datum vertical.', 139);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('CA030', 'Punto Acotado/de Cota', 'Lugar designado con un valor de elevación relativa con respecto a un datum vertical.', 140);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB010', 'Acantilado', 'Superficie empinada vertical o dominante de una roca o de la tierra.', 141);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB170', 'Duna', 'Uno o varios montículos o lomas de arena por lo general formadas por el viento.', 142);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB029', 'Entrada de Cueva', 'Entrada a una serie interconectada de cámaras subterráneas.', 143);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB160', 'Estrato Rocoso', 'Importante afloramiento del lecho rocoso expuesto.', 144);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB061', 'Grieta', 'Hendidura, fisura, abertura muy fina en la superficie de la tierra, especialmente en la roca.', 145);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ099', 'Límite de Nieve', 'Capa permanente de hielo que cubre una extensión de tierra  o  la cima de una montaña.', 146);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB090', 'Terraplén', 'Montículo largo de tierra u otro material, realizado por el hombre, que se levanta para hacer una defensa, camino u otra obra semejante.', 147);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA010', 'Característica del Suelo', 'Región de la tierra que es homogénea con respecto a una característica del suelo.', 148);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH160', 'Salitral', 'Yacimiento natural cuyo lecho está cubierto con sal  incrustada.', 149);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH150', 'Salina', 'Mina de sal.', 150);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB185', 'Cráter', 'Depresión en el terreno en forma cóncava, generalmente redonda y con bordes escarpados.', 151);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL045', 'Objeto Agregado', 'Lugar que no aparece como un objeto específico, pero con cual la información específica es asociada.', 195);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BJ030', 'Glaciar', 'Gran masa o un río de hielo que se forma por acumulación y  compactación de la nieve en  un terreno alto que se mueve  lentamente por una pendiente o valle por encima de la línea de nieve.', 152);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC040', 'Desmonte', 'Zona de terreno donde se ha desbrozado la vegetación; para facilitar principalmente: el acceso de una carretera, ferrocarril, tubería, línea de transmisión eléctrica; demarcar una frontera; obtener línea de vista, o para impedir el progreso de los incendios forestales (un cortafuegos).', 153);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD020', 'Zona sin Información', 'Área que carece de fuentes de cobertura adecuada o donde no se requiere información.', 154);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA010', 'Cultivo', 'Área que ha sido labrada para plantar diferentes cosechas; se incluyen terrenos con barbecho.', 155);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EA030', 'Vivero', 'Lugar donde arbustos, flores, plantas y árboles se cultivan para transplante, semilla o injerto.', 156);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB020', 'Matorral', 'Zona cubierta principalmente por especies arbustivas no cultivadas, que están densamente enredadas entre sí.', 157);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EB010', 'Pastizal', 'Vegetación herbácea o pasto que tienen poco o ningún tejido leñoso.', 158);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC005', 'Árbol', 'Planta perenne, de tronco leñoso que crece a una altura considerable y se ramifica a cierta distancia del suelo.', 159);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC015', 'Bosque', 'Área con alta densidad de árboles, a veces combinada con maleza y pasto.', 160);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EC060', 'Claro de Bosque', 'Sitio en un bosque que ha sido limpiado, a menudo por la agricultura de corte, quema y/o como resultado de la tala maderera. También puede producirse por causas naturales, tales como un incendio forestal.', 161);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('EE020', 'Tierra sin Vegetación', 'Una zona con cobertura menor al 5 % o sin vegetación.', 162);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED030', 'Zona de Manglar', 'Denso matorral de mangle que está sujeto a inundación por mareas y formación de pantanos.', 163);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ED020', 'Pantano', 'Terreno húmedo y lodoso, con un drenaje muy pobre, tiene cierto tipo de vegetación acuática y  dificulta el tránsito.', 164);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA000', 'Límite Administrativo', 'Límite entre zonas controladas administrativamente.', 165);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA001', 'Zona Administrativa', 'Área controlada mediante una autoridad administrativa.', 166);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB030', 'Hito', 'Marca que indica un punto físico sobre la superficie de la tierra cuya posición ha sido medida.', 167);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('IA041', 'Manzana', 'Superficie de terreno o agrupación de lotes cuyo conjunto está delimitado por vías de transito y/o accidentes geográficos naturales.', 168);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB060', 'Vértice Geodésico', 'Punto físico sobre la superficie de la tierra que tiene una posición conocida y se estableció como parte de una red geodésica.', 169);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB005', 'Aeropuerto', 'Zona provista de un conjunto de pistas, instalaciones y servicios destinados al tráfico regular de aeronaves.', 170);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB015', 'Estacionamiento de Aeronaves', 'Área definida, en un aeródromo terrestre/helipuerto, destinado a acoger aeronaves y helicópteros  para el embarque y desembarque de pasajeros, correo o carga y para abastecerse de combustible, estacionamiento  o mantenimiento.', 171);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB035', 'Helipuerto', 'Aeródromo utilizado para aterrizaje y despegue vertical de helicópteros.', 172);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB055', 'Pista de Aterrizaje', 'Área rectangular definida en un campo de aviación o aeropuerto, utilizada para despegue y aterrizaje de aeronaves.', 173);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('GB075', 'Pista de Rodadura', 'Ruta definida en un aeródromo, establecido para  el rodaje de aeronaves  y destinada a proporcionar un enlace de movimiento en tierra  entre una parte del aeródromo y otra.', 174);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('SU001', 'Base Militar', 'Conjunto de instalaciones destinadas para el uso militar, que proporcionan apoyo en combate, a fin de que cuenten con las mejores condiciones operativas para el cumplimiento de las tareas asignadas; brindando un soporte  logístico, técnico y de seguridad necesarios.', 175);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AT045', 'Estación de Radar', 'Instalación que utiliza el radar para detectar y analizar objetos (por ejemplo: aviones, buques, satélites artificiales, asteroides, y/o misiles) y/o fenómenos ambientales (por ejemplo: tornados).', 177);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AM065', 'Instalación de Almacenamiento de Municiones', 'Depósito para el almacenamiento y mantenimiento de municiones y explosivos (por ejemplo: bombas, misiles, ojivas, minas o municiones).', 178);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AH070', 'Puesto de Control', 'Lugar donde se registran, declaran y/o inspeccionan bienes y/o personas.', 179);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AL121', 'Zona de Artillería Anti-Aérea', 'Zona de instalaciones relacionadas (por ejemplo: edificios y/o equipos de radar) para el almacenamiento y emplazamiento de artillería anti-aérea.', 180);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC050', 'Área de Disparo y/o Práctica Naval', 'Área donde la fuerza naval (por ejemplo:buques o aeronaves) ejecutan ejercicios de disparo de munición  y lanzamiento de misiles en forma real.', 181);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA165', 'Área de Entrenamiento', 'Sitio destinado a la instrucción y adiestramiento especializado del personal movilizado para completar las dotaciones de guerra de las unidades y reparticiones del ejercito, así como para proporcionar los reemplazos necesarios a las tropas en combate.', 182);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC055', 'Área de Operaciones Navales', 'Área donde la fuerza naval ejecuta operaciones.', 183);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC200', 'Campo Minado', 'Parte del terreno sembrado de minas Antitanques y Antipersonal está destinado a retardar, desgastar y encauzar al adversario. En guerra naval es área de mar sembrada de minas antibuque y/o antisubmarinas, con el propósito de impedir el tráfico marítimo enemigo y/o proteger lugares de interés en el litoral, tales como puertos, bahías y canales.', 184);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA021', 'Límite Marítimo', 'Línea donde actividades determinadas o ciertos factores aplican tanto para la navegación u operación.', 185);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA015', 'Polígono de Tiro', 'Sitio designado con el propósito de disparar municiones y detonar explosivos.', 186);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FA517', 'Unidad Militar', 'Área que es de responsabilidad de un comando jurisdiccional.', 187);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('FC046', 'Área de un Cuerpo de Agua', 'Cuerpo de agua geográficamente definido (por ejemplo: el mar u otras aguas navegables).', 188);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI015', 'Colección de Nombres', 'Conjunto de nombres geográficos recogidos por una entidad de modelo que los utiliza para denotar una características junto con una ubicación geográfica adecuada para su uso en nomenclátor.', 189);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DA031', 'Denominación de la Parcela de Tierra', 'Parcela de un territorio natural, definido por sus características geográficas y conocido por su propio nombre.', 190);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD040', 'Nombre de Sitio', 'Sitio geográfico sobre la superficie de la tierra que tiene nombre propio.', 191);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI005', 'Nombre Geográfico', 'Nombre usado para denotar un objeto y la información de relación para establecer el contexto del uso, por parte de una entidad de modelo específica (por ejemplo: base de datos geográfica).', 192);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('DB000', 'Superficie de la Tierra', 'Parte de la tierra geográficamente definida.', 193);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZI033', 'Series', 'Para representar las hojas que de acuerdo a la escala se dividen para cubrir el país', 194);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZD012', 'Punto de Información Geográfica', 'Región en la que múltiples características que tiene la misma función  se representa como  objeto contiguo agregado.', 196);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AI030', 'Campamento Militar', 'Instalaciones generalmente en terreno abierto que pueden ser movidas con facilidad, sirven como residencia a tiempo completo o temporal.', 176);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BD122', 'Banco de Arena', 'Acumulación de arena, grava o guijarros en el lecho de un río.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('BH165', 'Aliviadero', 'Estructura hidráulica destinada a permitir el pase libre o controlado del agua en los escurrimientos superficiales; siendo el aliviadero en exclusiva para el desagüe.', 0);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ035', 'Acera', 'Ruta pavimentada o mejorada para uso del peatón, normalmente se encuentra adyacente y paralela a una calle o carretera. ', 197);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AQ037', 'Bordillo', 'Borde de hormigón, asfalto o piedras que forman el borde de una acera a lo largo de la orilla de una calle o carretera. Se debe incluir aquellos que formen parte de los parterres.', 198);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('AJ110', 'Invernadero', 'Edificio construido principalmente de material transparente en el que la temperatura y la humedad puede ser controlada para el cultivo y/o protección de plantas.', 199);
INSERT INTO catalogo_objetos.catalogo_objetos VALUES ('ZB050', 'Punto de Control', 'Objeto en el terreno de ubicación conocida, donde se ha determinado las coordenadas horizontal y/o vertical por métodos geodésicos o topográficos.', 200);


--
-- TOC entry 7341 (class 0 OID 2453929)
-- Dependencies: 316
-- Data for Name: dit; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.dit VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.dit VALUES (1, '1.- Irrigación');
INSERT INTO catalogo_objetos.dit VALUES (2, '2.- Drenaje');
INSERT INTO catalogo_objetos.dit VALUES (3, '3.- Aguas residuales');
INSERT INTO catalogo_objetos.dit VALUES (998, '998.- No aplica');


--
-- TOC entry 7342 (class 0 OID 2453932)
-- Dependencies: 317
-- Data for Name: ela; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.ela VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.ela VALUES (1, '1.- Preciso');
INSERT INTO catalogo_objetos.ela VALUES (2, '2.- Aproximado');
INSERT INTO catalogo_objetos.ela VALUES (998, '998.- No aplica');


--
-- TOC entry 7343 (class 0 OID 2453935)
-- Dependencies: 318
-- Data for Name: fco; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fco VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fco VALUES (1, '1.- Disperso');
INSERT INTO catalogo_objetos.fco VALUES (5, '5.- Divido en igual ancho');
INSERT INTO catalogo_objetos.fco VALUES (6, '6.- Dividido en diferente ancho');
INSERT INTO catalogo_objetos.fco VALUES (7, '7.- Sin divisiones');
INSERT INTO catalogo_objetos.fco VALUES (998, '998.- No aplica');


--
-- TOC entry 7344 (class 0 OID 2453938)
-- Dependencies: 319
-- Data for Name: fti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fti VALUES (1, '1.- Metal');
INSERT INTO catalogo_objetos.fti VALUES (2, '2.- Madera');
INSERT INTO catalogo_objetos.fti VALUES (3, '3.- Mampostería');
INSERT INTO catalogo_objetos.fti VALUES (4, '4.- Roca');
INSERT INTO catalogo_objetos.fti VALUES (5, '5.- Alambre de púas');
INSERT INTO catalogo_objetos.fti VALUES (6, '6.- Malla');
INSERT INTO catalogo_objetos.fti VALUES (7, '7.- Cable electrificado');
INSERT INTO catalogo_objetos.fti VALUES (8, '8.- Geotextil');
INSERT INTO catalogo_objetos.fti VALUES (9, '9.- Redes');
INSERT INTO catalogo_objetos.fti VALUES (998, '998.- No aplica');


--
-- TOC entry 7345 (class 0 OID 2453941)
-- Dependencies: 320
-- Data for Name: fuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.fuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.fuc VALUES (1, '1.- Industrial');
INSERT INTO catalogo_objetos.fuc VALUES (2, '2.- Comercial');
INSERT INTO catalogo_objetos.fuc VALUES (3, '3.- Institucional');
INSERT INTO catalogo_objetos.fuc VALUES (4, '4.- Residencial');
INSERT INTO catalogo_objetos.fuc VALUES (5, '5.- Agricultura');
INSERT INTO catalogo_objetos.fuc VALUES (6, '6.- Marítimo');
INSERT INTO catalogo_objetos.fuc VALUES (8, '8.- Refugio');
INSERT INTO catalogo_objetos.fuc VALUES (9, '9.- Correccional');
INSERT INTO catalogo_objetos.fuc VALUES (10, '10.- Santuario de vida salvaje');
INSERT INTO catalogo_objetos.fuc VALUES (12, '12.- Reserva');
INSERT INTO catalogo_objetos.fuc VALUES (13, '13.- Recreacional');
INSERT INTO catalogo_objetos.fuc VALUES (19, '19.- Urbanización multifuncional');
INSERT INTO catalogo_objetos.fuc VALUES (20, '20.- Transportación');
INSERT INTO catalogo_objetos.fuc VALUES (23, '23.- Medicina');
INSERT INTO catalogo_objetos.fuc VALUES (24, '24.- Preservación forestal');
INSERT INTO catalogo_objetos.fuc VALUES (26, '26.- Educacional');
INSERT INTO catalogo_objetos.fuc VALUES (27, '27.- No comercial');
INSERT INTO catalogo_objetos.fuc VALUES (31, '31.- Cultural');
INSERT INTO catalogo_objetos.fuc VALUES (32, '32.- Gubernamental');
INSERT INTO catalogo_objetos.fuc VALUES (33, '33.- Área prohibida');
INSERT INTO catalogo_objetos.fuc VALUES (34, '34.- Servicio público');
INSERT INTO catalogo_objetos.fuc VALUES (35, '35.- Religioso');
INSERT INTO catalogo_objetos.fuc VALUES (36, '36.- Seguridad');
INSERT INTO catalogo_objetos.fuc VALUES (37, '37.- Militar');
INSERT INTO catalogo_objetos.fuc VALUES (38, '38.- Empresa de Servicio Público');
INSERT INTO catalogo_objetos.fuc VALUES (39, '39.- Recursos para ingeniería o construcción');
INSERT INTO catalogo_objetos.fuc VALUES (40, '40.- Almacenamiento al granel');
INSERT INTO catalogo_objetos.fuc VALUES (41, '41.- Área de oficina');
INSERT INTO catalogo_objetos.fuc VALUES (42, '42.- Investigación');
INSERT INTO catalogo_objetos.fuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7346 (class 0 OID 2453944)
-- Dependencies: 321
-- Data for Name: hct; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hct VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hct VALUES (1, '1.- Ruta primaria');
INSERT INTO catalogo_objetos.hct VALUES (2, '2.- Ruta secundaria');
INSERT INTO catalogo_objetos.hct VALUES (3, '3.- Autopista nacional');
INSERT INTO catalogo_objetos.hct VALUES (4, '4.- Ruta local');
INSERT INTO catalogo_objetos.hct VALUES (998, '998.- No aplica');


--
-- TOC entry 7347 (class 0 OID 2453947)
-- Dependencies: 322
-- Data for Name: hyp; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.hyp VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.hyp VALUES (1, '1.- Perenne');
INSERT INTO catalogo_objetos.hyp VALUES (2, '2.- Intermitente');
INSERT INTO catalogo_objetos.hyp VALUES (3, '3.- Eventual');
INSERT INTO catalogo_objetos.hyp VALUES (4, '4.- Seco');
INSERT INTO catalogo_objetos.hyp VALUES (998, '998.- No aplica');


--
-- TOC entry 7348 (class 0 OID 2453950)
-- Dependencies: 323
-- Data for Name: kos; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.kos VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.kos VALUES (1, '1.- Fútbol');
INSERT INTO catalogo_objetos.kos VALUES (2, '2.- Campo de atletismo');
INSERT INTO catalogo_objetos.kos VALUES (3, '3.- Tenis');
INSERT INTO catalogo_objetos.kos VALUES (4, '4.- Equitación');
INSERT INTO catalogo_objetos.kos VALUES (5, '5.- Natación');
INSERT INTO catalogo_objetos.kos VALUES (6, '6.- Pista de esquí');
INSERT INTO catalogo_objetos.kos VALUES (7, '7.- Patinaje de hielo');
INSERT INTO catalogo_objetos.kos VALUES (8, '8.- Deportes de motor');
INSERT INTO catalogo_objetos.kos VALUES (10, '10.- Carreras de perros');
INSERT INTO catalogo_objetos.kos VALUES (11, '11.- Esquí a campo traviesa');
INSERT INTO catalogo_objetos.kos VALUES (12, '12.- Golf');
INSERT INTO catalogo_objetos.kos VALUES (13, '13.- Navegación a vela');
INSERT INTO catalogo_objetos.kos VALUES (14, '14.- Pista de obstáculos');
INSERT INTO catalogo_objetos.kos VALUES (998, '998.- No aplica');


--
-- TOC entry 7349 (class 0 OID 2453953)
-- Dependencies: 324
-- Data for Name: loc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.loc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.loc VALUES (17, '17.- Sobre el fondo de un cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (23, '23.- Bajo el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (40, '40.- Bajo la superficie');
INSERT INTO catalogo_objetos.loc VALUES (44, '44.- En la superficie');
INSERT INTO catalogo_objetos.loc VALUES (45, '45.- Sobre la superficie');
INSERT INTO catalogo_objetos.loc VALUES (46, '46.- Sobre el fondo del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (47, '47.- Bajo la superficie del cuerpo de agua');
INSERT INTO catalogo_objetos.loc VALUES (998, '998.- No aplica');


--
-- TOC entry 7350 (class 0 OID 2453956)
-- Dependencies: 325
-- Data for Name: mes; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.mes VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.mes VALUES (1, '1.- Verdadero');


--
-- TOC entry 7351 (class 0 OID 2453959)
-- Dependencies: 326
-- Data for Name: rdt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rdt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rdt VALUES (2, '2.- Tránsito rápido');
INSERT INTO catalogo_objetos.rdt VALUES (3, '3.- Privada');
INSERT INTO catalogo_objetos.rdt VALUES (4, '4.- Servicio');
INSERT INTO catalogo_objetos.rdt VALUES (5, '5.- Alta velocidad');
INSERT INTO catalogo_objetos.rdt VALUES (6, '6.- Ruta');
INSERT INTO catalogo_objetos.rdt VALUES (7, '7.- Circunvalación');
INSERT INTO catalogo_objetos.rdt VALUES (11, '11.- Camino corto');
INSERT INTO catalogo_objetos.rdt VALUES (45, '45.- Camino de herradura');
INSERT INTO catalogo_objetos.rdt VALUES (46, '46.- Cruce/intersección de caminos');
INSERT INTO catalogo_objetos.rdt VALUES (998, '998.- No aplica');


--
-- TOC entry 7352 (class 0 OID 2453962)
-- Dependencies: 327
-- Data for Name: rel; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rel VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rel VALUES (1, '1.- Budismo');
INSERT INTO catalogo_objetos.rel VALUES (2, '2.- Islam');
INSERT INTO catalogo_objetos.rel VALUES (3, '3.- Católica Romana');
INSERT INTO catalogo_objetos.rel VALUES (4, '4.- Cristiana');
INSERT INTO catalogo_objetos.rel VALUES (5, '5.- Judaísmo');
INSERT INTO catalogo_objetos.rel VALUES (6, '6.- Ortodoxa');
INSERT INTO catalogo_objetos.rel VALUES (7, '7.- Protestante');
INSERT INTO catalogo_objetos.rel VALUES (8, '8.- Sintoísmo');
INSERT INTO catalogo_objetos.rel VALUES (9, '9.- Hinduismo');
INSERT INTO catalogo_objetos.rel VALUES (10, '10.- Chiísmo');
INSERT INTO catalogo_objetos.rel VALUES (11, '11.- Suníes');
INSERT INTO catalogo_objetos.rel VALUES (12, '12.- Nestoriana');
INSERT INTO catalogo_objetos.rel VALUES (13, '13.- Caldea');
INSERT INTO catalogo_objetos.rel VALUES (15, '15.- Religión tribal');
INSERT INTO catalogo_objetos.rel VALUES (998, '998.- No aplica');


--
-- TOC entry 7353 (class 0 OID 2453965)
-- Dependencies: 328
-- Data for Name: rgc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rgc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rgc VALUES (1, '1.- Amplia');
INSERT INTO catalogo_objetos.rgc VALUES (2, '2.- Angosta/estrecha');
INSERT INTO catalogo_objetos.rgc VALUES (3, '3.- Estándar/normal');
INSERT INTO catalogo_objetos.rgc VALUES (6, '6.- Monocarril');
INSERT INTO catalogo_objetos.rgc VALUES (998, '998.- No aplica');


--
-- TOC entry 7354 (class 0 OID 2453968)
-- Dependencies: 329
-- Data for Name: rra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rra VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rra VALUES (1, '1.- Carril electrificado');
INSERT INTO catalogo_objetos.rra VALUES (3, '3.- Electrificación aérea');
INSERT INTO catalogo_objetos.rra VALUES (4, '4.- No electrificada');
INSERT INTO catalogo_objetos.rra VALUES (998, '998.- No aplica');


--
-- TOC entry 7355 (class 0 OID 2453971)
-- Dependencies: 330
-- Data for Name: rrc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rrc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rrc VALUES (2, '2.- Carline');
INSERT INTO catalogo_objetos.rrc VALUES (6, '6.- Ferrocarril subterráneo');
INSERT INTO catalogo_objetos.rrc VALUES (8, '8.- Transporte para madera');
INSERT INTO catalogo_objetos.rrc VALUES (10, '10.- Miniatura');
INSERT INTO catalogo_objetos.rrc VALUES (11, '11.- Tránsito rápido (Metro)');
INSERT INTO catalogo_objetos.rrc VALUES (13, '13.- Ferrocarril ayuda marina');
INSERT INTO catalogo_objetos.rrc VALUES (14, '14.- Tranvía');
INSERT INTO catalogo_objetos.rrc VALUES (15, '15.- Funicular');
INSERT INTO catalogo_objetos.rrc VALUES (24, '24.- Museo');
INSERT INTO catalogo_objetos.rrc VALUES (32, '32.- Sistema de tránsito automatizado');
INSERT INTO catalogo_objetos.rrc VALUES (33, '33.- Larga distancia');
INSERT INTO catalogo_objetos.rrc VALUES (998, '998.-  No aplica');


--
-- TOC entry 7356 (class 0 OID 2453974)
-- Dependencies: 331
-- Data for Name: rst; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.rst VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.rst VALUES (1, '1.- Duro/pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (2, '2.- Suelto/no pavimentado');
INSERT INTO catalogo_objetos.rst VALUES (3, '3.- Suelto/ligero');
INSERT INTO catalogo_objetos.rst VALUES (4, '4.- Troncos entrecruzados');
INSERT INTO catalogo_objetos.rst VALUES (5, '5.- Hierba/césped');
INSERT INTO catalogo_objetos.rst VALUES (6, '6.- Sin mejoras');
INSERT INTO catalogo_objetos.rst VALUES (7, '7.- Permanente');
INSERT INTO catalogo_objetos.rst VALUES (8, '8.- Temporal');
INSERT INTO catalogo_objetos.rst VALUES (9, '9.- Composición dura');
INSERT INTO catalogo_objetos.rst VALUES (10, '10.- PEM');
INSERT INTO catalogo_objetos.rst VALUES (11, '11.- Bituminosas');
INSERT INTO catalogo_objetos.rst VALUES (12, '12.- Composición suave');
INSERT INTO catalogo_objetos.rst VALUES (13, '13.- Tierra clasificada');
INSERT INTO catalogo_objetos.rst VALUES (14, '14.- Tierra sin clasificar');
INSERT INTO catalogo_objetos.rst VALUES (15, '15.- Hielo');
INSERT INTO catalogo_objetos.rst VALUES (16, '16.- Nieve');
INSERT INTO catalogo_objetos.rst VALUES (17, '17.- Macadán');
INSERT INTO catalogo_objetos.rst VALUES (18, '18.- Membrana');
INSERT INTO catalogo_objetos.rst VALUES (19, '19.- Mezcla');
INSERT INTO catalogo_objetos.rst VALUES (20, '20.- Laterita');
INSERT INTO catalogo_objetos.rst VALUES (21, '21.- Arena');
INSERT INTO catalogo_objetos.rst VALUES (22, '22.- Asfalto sobre concreto');
INSERT INTO catalogo_objetos.rst VALUES (23, '23.- Encofrado de acero perforado');
INSERT INTO catalogo_objetos.rst VALUES (24, '24.- Grava');
INSERT INTO catalogo_objetos.rst VALUES (25, '25.- Coral');
INSERT INTO catalogo_objetos.rst VALUES (26, '26.- Arcilla');
INSERT INTO catalogo_objetos.rst VALUES (27, '27.- Concreto');
INSERT INTO catalogo_objetos.rst VALUES (28, '28.- Ladrillo');
INSERT INTO catalogo_objetos.rst VALUES (29, '29.- Asfáltica');
INSERT INTO catalogo_objetos.rst VALUES (30, '30.- Ceniza');
INSERT INTO catalogo_objetos.rst VALUES (31, '31.- Empedrada');
INSERT INTO catalogo_objetos.rst VALUES (32, '32.- Concha');
INSERT INTO catalogo_objetos.rst VALUES (33, '33.- Tablón de madera');
INSERT INTO catalogo_objetos.rst VALUES (998, '998.- No aplica');


--
-- TOC entry 7357 (class 0 OID 2453977)
-- Dependencies: 332
-- Data for Name: slt; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.slt VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.slt VALUES (6, '6.- Manglar');
INSERT INTO catalogo_objetos.slt VALUES (8, '8.- Pantano');
INSERT INTO catalogo_objetos.slt VALUES (11, '11.- Escombros de construcción');
INSERT INTO catalogo_objetos.slt VALUES (12, '12.- Escombros de erosión');
INSERT INTO catalogo_objetos.slt VALUES (13, '13.- Arenoso');
INSERT INTO catalogo_objetos.slt VALUES (14, '14.- Guijarros');
INSERT INTO catalogo_objetos.slt VALUES (15, '15.- Rocoso');
INSERT INTO catalogo_objetos.slt VALUES (16, '16.- Coral');
INSERT INTO catalogo_objetos.slt VALUES (17, '17.- Hielo');
INSERT INTO catalogo_objetos.slt VALUES (18, '18.- Barro');
INSERT INTO catalogo_objetos.slt VALUES (998, '998.- No aplica');


--
-- TOC entry 7358 (class 0 OID 2453980)
-- Dependencies: 333
-- Data for Name: smc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.smc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.smc VALUES (2, '2.- Aluminio');
INSERT INTO catalogo_objetos.smc VALUES (4, '4.- Ceniza');
INSERT INTO catalogo_objetos.smc VALUES (5, '5.- Asfalto');
INSERT INTO catalogo_objetos.smc VALUES (6, '6.- Basalto');
INSERT INTO catalogo_objetos.smc VALUES (7, '7.- Roca Madre');
INSERT INTO catalogo_objetos.smc VALUES (8, '8.- Cantos Rodados');
INSERT INTO catalogo_objetos.smc VALUES (9, '9.- Ladrillo');
INSERT INTO catalogo_objetos.smc VALUES (10, '10.- Calcáreo');
INSERT INTO catalogo_objetos.smc VALUES (12, '12.- Tiza');
INSERT INTO catalogo_objetos.smc VALUES (14, '14.- Cenizas');
INSERT INTO catalogo_objetos.smc VALUES (15, '15.- Cirripedia');
INSERT INTO catalogo_objetos.smc VALUES (16, '16.- Arcilla');
INSERT INTO catalogo_objetos.smc VALUES (17, '17.- Carbón');
INSERT INTO catalogo_objetos.smc VALUES (18, '18.- Empedrado');
INSERT INTO catalogo_objetos.smc VALUES (19, '19.- Coque');
INSERT INTO catalogo_objetos.smc VALUES (20, '20.- Composición');
INSERT INTO catalogo_objetos.smc VALUES (21, '21.- Concreto u Hormigón');
INSERT INTO catalogo_objetos.smc VALUES (22, '22.- Conglomerado');
INSERT INTO catalogo_objetos.smc VALUES (23, '23.- Cobre');
INSERT INTO catalogo_objetos.smc VALUES (24, '24.- Coral');
INSERT INTO catalogo_objetos.smc VALUES (25, '25.- Coral Head');
INSERT INTO catalogo_objetos.smc VALUES (28, '28.- Tierra de diatomeas');
INSERT INTO catalogo_objetos.smc VALUES (29, '29.- Dolomita');
INSERT INTO catalogo_objetos.smc VALUES (34, '34.- Flysch');
INSERT INTO catalogo_objetos.smc VALUES (36, '36.- Foraminíferos');
INSERT INTO catalogo_objetos.smc VALUES (37, '37.- Fucus');
INSERT INTO catalogo_objetos.smc VALUES (40, '40.- Vidrio');
INSERT INTO catalogo_objetos.smc VALUES (42, '42.- Oro');
INSERT INTO catalogo_objetos.smc VALUES (43, '43.- Granito');
INSERT INTO catalogo_objetos.smc VALUES (45, '45.- Materia vegetal');
INSERT INTO catalogo_objetos.smc VALUES (46, '46.- Grava');
INSERT INTO catalogo_objetos.smc VALUES (47, '47.- Rocaverde (Jade)');
INSERT INTO catalogo_objetos.smc VALUES (49, '49.- Suelo  de conchas');
INSERT INTO catalogo_objetos.smc VALUES (51, '51.- Hierro');
INSERT INTO catalogo_objetos.smc VALUES (52, '52.- Lava');
INSERT INTO catalogo_objetos.smc VALUES (54, '54.- Plomo');
INSERT INTO catalogo_objetos.smc VALUES (55, '55.- Loess');
INSERT INTO catalogo_objetos.smc VALUES (56, '56.- Maderos');
INSERT INTO catalogo_objetos.smc VALUES (57, '57.- Macadán');
INSERT INTO catalogo_objetos.smc VALUES (58, '58.- Madrépora');
INSERT INTO catalogo_objetos.smc VALUES (59, '59.- Manganeso');
INSERT INTO catalogo_objetos.smc VALUES (60, '60.- Mármol');
INSERT INTO catalogo_objetos.smc VALUES (61, '61.- Marga');
INSERT INTO catalogo_objetos.smc VALUES (62, '62.- Mampostería');
INSERT INTO catalogo_objetos.smc VALUES (63, '63.- Mate');
INSERT INTO catalogo_objetos.smc VALUES (64, '64.- Metal');
INSERT INTO catalogo_objetos.smc VALUES (65, '65.- Barro');
INSERT INTO catalogo_objetos.smc VALUES (66, '66.- Mejillones');
INSERT INTO catalogo_objetos.smc VALUES (67, '67.- Aceite');
INSERT INTO catalogo_objetos.smc VALUES (69, '69.- Cieno');
INSERT INTO catalogo_objetos.smc VALUES (70, '70.- Ostras');
INSERT INTO catalogo_objetos.smc VALUES (71, '71.- Papel');
INSERT INTO catalogo_objetos.smc VALUES (72, '72.- Parte  Metálica');
INSERT INTO catalogo_objetos.smc VALUES (73, '73.- Guijarros');
INSERT INTO catalogo_objetos.smc VALUES (74, '74.- Plástico');
INSERT INTO catalogo_objetos.smc VALUES (75, '75.- Algas marinas');
INSERT INTO catalogo_objetos.smc VALUES (76, '76.- Pórfido');
INSERT INTO catalogo_objetos.smc VALUES (77, '77.- Hormigón pretensado');
INSERT INTO catalogo_objetos.smc VALUES (79, '79.- Piedra Pómez');
INSERT INTO catalogo_objetos.smc VALUES (80, '80.- Cuarzo');
INSERT INTO catalogo_objetos.smc VALUES (81, '81.- Radiolario');
INSERT INTO catalogo_objetos.smc VALUES (82, '82.- Material radiactivo');
INSERT INTO catalogo_objetos.smc VALUES (83, '83.- Hormigón armado');
INSERT INTO catalogo_objetos.smc VALUES (84, '84.- Piedras');
INSERT INTO catalogo_objetos.smc VALUES (85, '85.- Caucho');
INSERT INTO catalogo_objetos.smc VALUES (86, '86.- Escombros');
INSERT INTO catalogo_objetos.smc VALUES (87, '87.- Sal');
INSERT INTO catalogo_objetos.smc VALUES (88, '88.- Arena');
INSERT INTO catalogo_objetos.smc VALUES (89, '89.- Arenisca');
INSERT INTO catalogo_objetos.smc VALUES (90, '90.- Esquisto');
INSERT INTO catalogo_objetos.smc VALUES (91, '91.- Desperdicio de minas');
INSERT INTO catalogo_objetos.smc VALUES (92, '92.- Escoria');
INSERT INTO catalogo_objetos.smc VALUES (95, '95.- Aguas Residuales');
INSERT INTO catalogo_objetos.smc VALUES (96, '96.- Concha');
INSERT INTO catalogo_objetos.smc VALUES (98, '98.- Guijarro');
INSERT INTO catalogo_objetos.smc VALUES (99, '99.- Limo');
INSERT INTO catalogo_objetos.smc VALUES (100, '100.- Plata');
INSERT INTO catalogo_objetos.smc VALUES (101, '101.- Desechos de metales');
INSERT INTO catalogo_objetos.smc VALUES (102, '102.- Lodos');
INSERT INTO catalogo_objetos.smc VALUES (103, '103.- Agua congelada');
INSERT INTO catalogo_objetos.smc VALUES (104, '104.- Suelo');
INSERT INTO catalogo_objetos.smc VALUES (105, '105.- Espículas');
INSERT INTO catalogo_objetos.smc VALUES (106, '106.- Esponja');
INSERT INTO catalogo_objetos.smc VALUES (107, '107.- Acero');
INSERT INTO catalogo_objetos.smc VALUES (108, '108.- Piedra preciosa');
INSERT INTO catalogo_objetos.smc VALUES (110, '110.- Travertino');
INSERT INTO catalogo_objetos.smc VALUES (111, '111.- Toba');
INSERT INTO catalogo_objetos.smc VALUES (112, '112.- Mineral de  uranio');
INSERT INTO catalogo_objetos.smc VALUES (113, '113.- Vegetación');
INSERT INTO catalogo_objetos.smc VALUES (115, '115.- Ceniza Volcánica');
INSERT INTO catalogo_objetos.smc VALUES (116, '116.- Agua');
INSERT INTO catalogo_objetos.smc VALUES (117, '117.- Madera');
INSERT INTO catalogo_objetos.smc VALUES (118, '118.- Zinc');
INSERT INTO catalogo_objetos.smc VALUES (120, '120.- Arena y Grava');
INSERT INTO catalogo_objetos.smc VALUES (121, '121.- Escollera');
INSERT INTO catalogo_objetos.smc VALUES (122, '122.- Evaporita');
INSERT INTO catalogo_objetos.smc VALUES (124, '124.- Arena y rocas');
INSERT INTO catalogo_objetos.smc VALUES (126, '126.- Arena y barro');
INSERT INTO catalogo_objetos.smc VALUES (128, '128.- Plástico reforzado con vidrio (GRP)');
INSERT INTO catalogo_objetos.smc VALUES (129, '129.- Roca metomórfica');
INSERT INTO catalogo_objetos.smc VALUES (130, '130.- Roca  ígnea');
INSERT INTO catalogo_objetos.smc VALUES (131, '131.- Dolerita');
INSERT INTO catalogo_objetos.smc VALUES (205, '205.- Pintura');
INSERT INTO catalogo_objetos.smc VALUES (257, '257.- Hielo');
INSERT INTO catalogo_objetos.smc VALUES (258, '258.- Nieve');
INSERT INTO catalogo_objetos.smc VALUES (262, '262.- Laterita');
INSERT INTO catalogo_objetos.smc VALUES (266, '266.- Breccia');
INSERT INTO catalogo_objetos.smc VALUES (267, '267.- Cerámica');
INSERT INTO catalogo_objetos.smc VALUES (268, '268.- Gneis');
INSERT INTO catalogo_objetos.smc VALUES (269, '269.- Caliza');
INSERT INTO catalogo_objetos.smc VALUES (270, '270.- Cuarcita');
INSERT INTO catalogo_objetos.smc VALUES (271, '271.- Teja');
INSERT INTO catalogo_objetos.smc VALUES (272, '272.- Lutita – esquisto');
INSERT INTO catalogo_objetos.smc VALUES (273, '273.- Pizarra');
INSERT INTO catalogo_objetos.smc VALUES (274, '274.- Césped');
INSERT INTO catalogo_objetos.smc VALUES (275, '275.- Paja');
INSERT INTO catalogo_objetos.smc VALUES (276, '276.- Madero');
INSERT INTO catalogo_objetos.smc VALUES (277, '277.- Roca sedimentaria');
INSERT INTO catalogo_objetos.smc VALUES (278, '278.- Adobe');
INSERT INTO catalogo_objetos.smc VALUES (279, '279.- Madera tratada');
INSERT INTO catalogo_objetos.smc VALUES (280, '280.- Pasto');
INSERT INTO catalogo_objetos.smc VALUES (998, '998.- No aplica');


--
-- TOC entry 7359 (class 0 OID 2453983)
-- Dependencies: 334
-- Data for Name: tra; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tra VALUES (0, '0.- Falso');
INSERT INTO catalogo_objetos.tra VALUES (1, '1.- Verdadero');


--
-- TOC entry 7360 (class 0 OID 2453986)
-- Dependencies: 335
-- Data for Name: tuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.tuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.tuc VALUES (19, '19.- Ganadería');
INSERT INTO catalogo_objetos.tuc VALUES (25, '25.- Carga');
INSERT INTO catalogo_objetos.tuc VALUES (26, '26.- Pasajeros');
INSERT INTO catalogo_objetos.tuc VALUES (33, '33.- Minerales');
INSERT INTO catalogo_objetos.tuc VALUES (35, '35.- No para transporte');
INSERT INTO catalogo_objetos.tuc VALUES (45, '45.- General');
INSERT INTO catalogo_objetos.tuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7361 (class 0 OID 2453989)
-- Dependencies: 336
-- Data for Name: typ; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.typ VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.typ VALUES (1, '1.- Carretera');
INSERT INTO catalogo_objetos.typ VALUES (5, '5.- Bulevar');
INSERT INTO catalogo_objetos.typ VALUES (9, '9.- Avenida');
INSERT INTO catalogo_objetos.typ VALUES (13, '13.- Paseo');
INSERT INTO catalogo_objetos.typ VALUES (17, '17.- Curva de retorno');
INSERT INTO catalogo_objetos.typ VALUES (21, '21.- Cerrada');
INSERT INTO catalogo_objetos.typ VALUES (25, '25.- Ruta verde (Parkway)');
INSERT INTO catalogo_objetos.typ VALUES (29, '29.- Pasaje');
INSERT INTO catalogo_objetos.typ VALUES (33, '33.- Calle');
INSERT INTO catalogo_objetos.typ VALUES (37, '37.- Terraza');
INSERT INTO catalogo_objetos.typ VALUES (41, '41.- Autopista');
INSERT INTO catalogo_objetos.typ VALUES (45, '45.- Plaza');
INSERT INTO catalogo_objetos.typ VALUES (46, '46.- Rodera');
INSERT INTO catalogo_objetos.typ VALUES (47, '47.- Autopista de acceso restringido');
INSERT INTO catalogo_objetos.typ VALUES (48, '48.- Redondel');
INSERT INTO catalogo_objetos.typ VALUES (49, '49.- Sendero');
INSERT INTO catalogo_objetos.typ VALUES (50, '50.- Rampa');
INSERT INTO catalogo_objetos.typ VALUES (998, '998.- No aplica');


--
-- TOC entry 7362 (class 0 OID 2453992)
-- Dependencies: 337
-- Data for Name: uuc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.uuc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.uuc VALUES (4, '4.- Transformador');
INSERT INTO catalogo_objetos.uuc VALUES (5, '5.- Desagüe');
INSERT INTO catalogo_objetos.uuc VALUES (6, '6.- Represa');
INSERT INTO catalogo_objetos.uuc VALUES (7, '7.- Agua potable');
INSERT INTO catalogo_objetos.uuc VALUES (9, '9.- Dependencia');
INSERT INTO catalogo_objetos.uuc VALUES (10, '10.- Central eléctrica');
INSERT INTO catalogo_objetos.uuc VALUES (11, '11.- Planta de filtración');
INSERT INTO catalogo_objetos.uuc VALUES (12, '12.- Refrigeración');
INSERT INTO catalogo_objetos.uuc VALUES (18, '18.- Central de abastecimiento de agua');
INSERT INTO catalogo_objetos.uuc VALUES (998, '998.- No aplica');


--
-- TOC entry 7363 (class 0 OID 2453995)
-- Dependencies: 338
-- Data for Name: wtc; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wtc VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wtc VALUES (1, '1.- Todo el tiempo (todo el año)');
INSERT INTO catalogo_objetos.wtc VALUES (3, '3.- Solamente en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (4, '4.- Limitada todo el tiempo');
INSERT INTO catalogo_objetos.wtc VALUES (5, '5.- Cerrada en invierno');
INSERT INTO catalogo_objetos.wtc VALUES (998, '998.- No aplica');
INSERT INTO catalogo_objetos.wtc VALUES (2, '2.- Buen clima (época seca)');


--
-- TOC entry 7364 (class 0 OID 2453998)
-- Dependencies: 339
-- Data for Name: wti; Type: TABLE DATA; Schema: catalogo_objetos; Owner: postgres
--

INSERT INTO catalogo_objetos.wti VALUES (-1, '-1.- Información no disponible');
INSERT INTO catalogo_objetos.wti VALUES (1, '1.- Independiente');
INSERT INTO catalogo_objetos.wti VALUES (2, '2.- Retener (obstaculizar)');
INSERT INTO catalogo_objetos.wti VALUES (4, '4.- Cercado con árboles');
INSERT INTO catalogo_objetos.wti VALUES (5, '5.- Cerramiento');
INSERT INTO catalogo_objetos.wti VALUES (998, '998.- No aplica');


--
-- TOC entry 7365 (class 0 OID 2454001)
-- Dependencies: 340
-- Data for Name: punto_control_p; Type: TABLE DATA; Schema: d_linderos_propiedad; Owner: postgres
--



--
-- TOC entry 7367 (class 0 OID 2454013)
-- Dependencies: 342
-- Data for Name: cementerio_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7369 (class 0 OID 2454025)
-- Dependencies: 344
-- Data for Name: cerca_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7371 (class 0 OID 2454037)
-- Dependencies: 346
-- Data for Name: escalinata_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7373 (class 0 OID 2454049)
-- Dependencies: 348
-- Data for Name: muro_l; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7375 (class 0 OID 2454061)
-- Dependencies: 350
-- Data for Name: plaza_publica_a; Type: TABLE DATA; Schema: gs_asociado_poblados; Owner: postgres
--



--
-- TOC entry 7377 (class 0 OID 2454073)
-- Dependencies: 352
-- Data for Name: edificio_a; Type: TABLE DATA; Schema: gs_construcciones; Owner: postgres
--



--
-- TOC entry 7379 (class 0 OID 2454085)
-- Dependencies: 354
-- Data for Name: cancha_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7381 (class 0 OID 2454097)
-- Dependencies: 356
-- Data for Name: estadio_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7383 (class 0 OID 2454109)
-- Dependencies: 358
-- Data for Name: parque_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7385 (class 0 OID 2454121)
-- Dependencies: 360
-- Data for Name: piscina_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7387 (class 0 OID 2454133)
-- Dependencies: 362
-- Data for Name: plaza_toros_a; Type: TABLE DATA; Schema: gs_recreacion; Owner: postgres
--



--
-- TOC entry 7389 (class 0 OID 2454145)
-- Dependencies: 364
-- Data for Name: acequia_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7391 (class 0 OID 2454157)
-- Dependencies: 366
-- Data for Name: acueducto_canal_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7393 (class 0 OID 2454169)
-- Dependencies: 368
-- Data for Name: lago_laguna_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7395 (class 0 OID 2454181)
-- Dependencies: 370
-- Data for Name: rio_a; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7397 (class 0 OID 2454193)
-- Dependencies: 372
-- Data for Name: rio_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7399 (class 0 OID 2454205)
-- Dependencies: 374
-- Data for Name: zanja_l; Type: TABLE DATA; Schema: ho_aguas_interiores; Owner: postgres
--



--
-- TOC entry 7401 (class 0 OID 2454217)
-- Dependencies: 376
-- Data for Name: puerto_a; Type: TABLE DATA; Schema: ho_puertos_muelles; Owner: postgres
--



--
-- TOC entry 7403 (class 0 OID 2454229)
-- Dependencies: 378
-- Data for Name: granja_acuatica_a; Type: TABLE DATA; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--



--
-- TOC entry 7405 (class 0 OID 2454241)
-- Dependencies: 380
-- Data for Name: isla_a; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7407 (class 0 OID 2454253)
-- Dependencies: 382
-- Data for Name: orilla_l; Type: TABLE DATA; Schema: ho_zonas_costeras; Owner: postgres
--



--
-- TOC entry 7409 (class 0 OID 2454265)
-- Dependencies: 384
-- Data for Name: invernadero_a; Type: TABLE DATA; Schema: ii_agropecuaria; Owner: postgres
--



--
-- TOC entry 7411 (class 0 OID 2454278)
-- Dependencies: 386
-- Data for Name: acera_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7413 (class 0 OID 2454290)
-- Dependencies: 388
-- Data for Name: bordillo_l; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7415 (class 0 OID 2454302)
-- Dependencies: 390
-- Data for Name: cuneta_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7417 (class 0 OID 2454314)
-- Dependencies: 392
-- Data for Name: parqueadero_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7419 (class 0 OID 2454326)
-- Dependencies: 394
-- Data for Name: paseo_peatonal_ciclovia_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7421 (class 0 OID 2454338)
-- Dependencies: 396
-- Data for Name: tunel_a; Type: TABLE DATA; Schema: it_asociado_transportacion; Owner: postgres
--



--
-- TOC entry 7423 (class 0 OID 2454350)
-- Dependencies: 398
-- Data for Name: puente_a; Type: TABLE DATA; Schema: it_cruces_enlaces; Owner: postgres
--



--
-- TOC entry 7425 (class 0 OID 2454362)
-- Dependencies: 400
-- Data for Name: ferrocarril_a; Type: TABLE DATA; Schema: it_ferrocarriles; Owner: postgres
--



--
-- TOC entry 7427 (class 0 OID 2454374)
-- Dependencies: 402
-- Data for Name: gasolinera_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7429 (class 0 OID 2454386)
-- Dependencies: 404
-- Data for Name: intercambiador_vial_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7431 (class 0 OID 2454398)
-- Dependencies: 406
-- Data for Name: rodera_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7433 (class 0 OID 2454410)
-- Dependencies: 408
-- Data for Name: sendero_l; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7435 (class 0 OID 2454422)
-- Dependencies: 410
-- Data for Name: via_ruta_a; Type: TABLE DATA; Schema: it_transporte_terrestre; Owner: postgres
--



--
-- TOC entry 7437 (class 0 OID 2454434)
-- Dependencies: 412
-- Data for Name: qgis_projects; Type: TABLE DATA; Schema: proyecto_qgis3; Owner: postgres
--

INSERT INTO proyecto_qgis3.qgis_projects VALUES ('CARTOGRAFIA BASE CATASTRAL', '{"last_modified_time": "2022-06-27 21:02:51.358831", "last_modified_user": "postgres"}', '\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');


--
-- TOC entry 6391 (class 0 OID 16696)
-- Dependencies: 237
-- Data for Name: spatial_ref_sys; Type: TABLE DATA; Schema: public; Owner: postgres
--

--
-- TOC entry 7526 (class 0 OID 0)
-- Dependencies: 310
-- Name: aeropuerto_a_gid_seq; Type: SEQUENCE SET; Schema: a_aeropuerto_superficie; Owner: postgres
--

SELECT pg_catalog.setval('a_aeropuerto_superficie.aeropuerto_a_gid_seq', 7, true);


--
-- TOC entry 7527 (class 0 OID 0)
-- Dependencies: 315
-- Name: catalogo_objetos_gid_seq; Type: SEQUENCE SET; Schema: catalogo_objetos; Owner: postgres
--

SELECT pg_catalog.setval('catalogo_objetos.catalogo_objetos_gid_seq', 200, true);


--
-- TOC entry 7528 (class 0 OID 0)
-- Dependencies: 341
-- Name: vertice_geodesico_p_gid_seq; Type: SEQUENCE SET; Schema: d_linderos_propiedad; Owner: postgres
--

SELECT pg_catalog.setval('d_linderos_propiedad.vertice_geodesico_p_gid_seq', 1, true);


--
-- TOC entry 7529 (class 0 OID 0)
-- Dependencies: 343
-- Name: cementerio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cementerio_a_gid_seq', 1, false);


--
-- TOC entry 7530 (class 0 OID 0)
-- Dependencies: 345
-- Name: cerca_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.cerca_l_gid_seq', 1, false);


--
-- TOC entry 7531 (class 0 OID 0)
-- Dependencies: 347
-- Name: escalinata_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.escalinata_a_gid_seq', 1, false);


--
-- TOC entry 7532 (class 0 OID 0)
-- Dependencies: 349
-- Name: muro_l_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.muro_l_gid_seq', 1, false);


--
-- TOC entry 7533 (class 0 OID 0)
-- Dependencies: 351
-- Name: plaza_publica_a_gid_seq; Type: SEQUENCE SET; Schema: gs_asociado_poblados; Owner: postgres
--

SELECT pg_catalog.setval('gs_asociado_poblados.plaza_publica_a_gid_seq', 1, false);


--
-- TOC entry 7534 (class 0 OID 0)
-- Dependencies: 353
-- Name: edificio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_construcciones; Owner: postgres
--

SELECT pg_catalog.setval('gs_construcciones.edificio_a_gid_seq', 1, false);


--
-- TOC entry 7535 (class 0 OID 0)
-- Dependencies: 355
-- Name: cancha_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.cancha_a_gid_seq', 1, false);


--
-- TOC entry 7536 (class 0 OID 0)
-- Dependencies: 357
-- Name: estadio_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.estadio_a_gid_seq', 1, false);


--
-- TOC entry 7537 (class 0 OID 0)
-- Dependencies: 359
-- Name: parque_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.parque_a_gid_seq', 1, false);


--
-- TOC entry 7538 (class 0 OID 0)
-- Dependencies: 361
-- Name: piscina_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.piscina_a_gid_seq', 1, false);


--
-- TOC entry 7539 (class 0 OID 0)
-- Dependencies: 363
-- Name: plaza_toros_a_gid_seq; Type: SEQUENCE SET; Schema: gs_recreacion; Owner: postgres
--

SELECT pg_catalog.setval('gs_recreacion.plaza_toros_a_gid_seq', 1, false);


--
-- TOC entry 7540 (class 0 OID 0)
-- Dependencies: 365
-- Name: acequia_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acequia_l_gid_seq', 1, false);


--
-- TOC entry 7541 (class 0 OID 0)
-- Dependencies: 367
-- Name: acueducto_canal_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.acueducto_canal_a_gid_seq', 1, false);


--
-- TOC entry 7542 (class 0 OID 0)
-- Dependencies: 369
-- Name: lago_laguna_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.lago_laguna_a_gid_seq', 1, false);


--
-- TOC entry 7543 (class 0 OID 0)
-- Dependencies: 371
-- Name: rio_a_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_a_gid_seq', 1, false);


--
-- TOC entry 7544 (class 0 OID 0)
-- Dependencies: 373
-- Name: rio_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.rio_l_gid_seq', 1, false);


--
-- TOC entry 7545 (class 0 OID 0)
-- Dependencies: 375
-- Name: zanja_l_gid_seq; Type: SEQUENCE SET; Schema: ho_aguas_interiores; Owner: postgres
--

SELECT pg_catalog.setval('ho_aguas_interiores.zanja_l_gid_seq', 1, false);


--
-- TOC entry 7546 (class 0 OID 0)
-- Dependencies: 377
-- Name: puerto_a_gid_seq; Type: SEQUENCE SET; Schema: ho_puertos_muelles; Owner: postgres
--

SELECT pg_catalog.setval('ho_puertos_muelles.puerto_a_gid_seq', 1, false);


--
-- TOC entry 7547 (class 0 OID 0)
-- Dependencies: 379
-- Name: granja_acuatica_a_gid_seq; Type: SEQUENCE SET; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

SELECT pg_catalog.setval('ho_regulacion_zonas_restringidas.granja_acuatica_a_gid_seq', 1, false);


--
-- TOC entry 7548 (class 0 OID 0)
-- Dependencies: 381
-- Name: isla_a_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.isla_a_gid_seq', 1, false);


--
-- TOC entry 7549 (class 0 OID 0)
-- Dependencies: 383
-- Name: orilla_l_gid_seq; Type: SEQUENCE SET; Schema: ho_zonas_costeras; Owner: postgres
--

SELECT pg_catalog.setval('ho_zonas_costeras.orilla_l_gid_seq', 1, false);


--
-- TOC entry 7550 (class 0 OID 0)
-- Dependencies: 385
-- Name: invernadero_a_gid_seq; Type: SEQUENCE SET; Schema: ii_agropecuaria; Owner: postgres
--

SELECT pg_catalog.setval('ii_agropecuaria.invernadero_a_gid_seq', 1, false);


--
-- TOC entry 7551 (class 0 OID 0)
-- Dependencies: 387
-- Name: acera_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.acera_a_gid_seq', 1, false);


--
-- TOC entry 7552 (class 0 OID 0)
-- Dependencies: 389
-- Name: bordillo_l_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.bordillo_l_gid_seq', 1, false);


--
-- TOC entry 7553 (class 0 OID 0)
-- Dependencies: 391
-- Name: cuneta_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.cuneta_a_gid_seq', 1, false);


--
-- TOC entry 7554 (class 0 OID 0)
-- Dependencies: 393
-- Name: parqueadero_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.parqueadero_a_gid_seq', 1, false);


--
-- TOC entry 7555 (class 0 OID 0)
-- Dependencies: 395
-- Name: paseo_peatonal_ciclovia_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.paseo_peatonal_ciclovia_a_gid_seq', 1, false);


--
-- TOC entry 7556 (class 0 OID 0)
-- Dependencies: 397
-- Name: tunel_a_gid_seq; Type: SEQUENCE SET; Schema: it_asociado_transportacion; Owner: postgres
--

SELECT pg_catalog.setval('it_asociado_transportacion.tunel_a_gid_seq', 1, false);


--
-- TOC entry 7557 (class 0 OID 0)
-- Dependencies: 399
-- Name: puente_a_gid_seq; Type: SEQUENCE SET; Schema: it_cruces_enlaces; Owner: postgres
--

SELECT pg_catalog.setval('it_cruces_enlaces.puente_a_gid_seq', 1, false);


--
-- TOC entry 7558 (class 0 OID 0)
-- Dependencies: 401
-- Name: ferrocarril_a_gid_seq; Type: SEQUENCE SET; Schema: it_ferrocarriles; Owner: postgres
--

SELECT pg_catalog.setval('it_ferrocarriles.ferrocarril_a_gid_seq', 1, false);


--
-- TOC entry 7559 (class 0 OID 0)
-- Dependencies: 403
-- Name: gasolinera_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.gasolinera_a_gid_seq', 1, false);


--
-- TOC entry 7560 (class 0 OID 0)
-- Dependencies: 405
-- Name: intercambiador_vial_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.intercambiador_vial_a_gid_seq', 1, false);


--
-- TOC entry 7561 (class 0 OID 0)
-- Dependencies: 407
-- Name: rodera_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.rodera_l_gid_seq', 14157, true);


--
-- TOC entry 7562 (class 0 OID 0)
-- Dependencies: 409
-- Name: sendero_l_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.sendero_l_gid_seq', 1, false);


--
-- TOC entry 7563 (class 0 OID 0)
-- Dependencies: 411
-- Name: via_ruta_a_gid_seq; Type: SEQUENCE SET; Schema: it_transporte_terrestre; Owner: postgres
--

SELECT pg_catalog.setval('it_transporte_terrestre.via_ruta_a_gid_seq', 105, true);


--
-- TOC entry 6846 (class 2606 OID 2454655)
-- Name: aeropuerto_a aeropuerto_a_pkey; Type: CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6849 (class 2606 OID 2454657)
-- Name: acc acc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.acc
    ADD CONSTRAINT acc_pkey PRIMARY KEY (acc);


--
-- TOC entry 6851 (class 2606 OID 2454659)
-- Name: atc atc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.atc
    ADD CONSTRAINT atc_pkey PRIMARY KEY (atc);


--
-- TOC entry 6853 (class 2606 OID 2454661)
-- Name: bsc bsc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.bsc
    ADD CONSTRAINT bsc_pkey PRIMARY KEY (bsc);


--
-- TOC entry 6855 (class 2606 OID 2454663)
-- Name: catalogo_objetos catalogo_objetos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.catalogo_objetos
    ADD CONSTRAINT catalogo_objetos_pkey PRIMARY KEY (fcode);


--
-- TOC entry 6857 (class 2606 OID 2454665)
-- Name: dit dit_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.dit
    ADD CONSTRAINT dit_pkey PRIMARY KEY (dit);


--
-- TOC entry 6859 (class 2606 OID 2454667)
-- Name: ela ela_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.ela
    ADD CONSTRAINT ela_pkey PRIMARY KEY (ela);


--
-- TOC entry 6861 (class 2606 OID 2454669)
-- Name: fco fco_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fco
    ADD CONSTRAINT fco_pkey PRIMARY KEY (fco);


--
-- TOC entry 6863 (class 2606 OID 2454671)
-- Name: fti fti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fti
    ADD CONSTRAINT fti_pkey PRIMARY KEY (fti);


--
-- TOC entry 6865 (class 2606 OID 2454673)
-- Name: fuc fuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.fuc
    ADD CONSTRAINT fuc_pkey PRIMARY KEY (fuc);


--
-- TOC entry 6867 (class 2606 OID 2454675)
-- Name: hct hct_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hct
    ADD CONSTRAINT hct_pkey PRIMARY KEY (hct);


--
-- TOC entry 6869 (class 2606 OID 2454677)
-- Name: hyp hyp_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.hyp
    ADD CONSTRAINT hyp_pkey PRIMARY KEY (hyp);


--
-- TOC entry 6871 (class 2606 OID 2454679)
-- Name: kos kos_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.kos
    ADD CONSTRAINT kos_pkey PRIMARY KEY (kos);


--
-- TOC entry 6873 (class 2606 OID 2454681)
-- Name: loc loc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.loc
    ADD CONSTRAINT loc_pkey PRIMARY KEY (loc);


--
-- TOC entry 6875 (class 2606 OID 2454683)
-- Name: mes mes_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.mes
    ADD CONSTRAINT mes_pkey PRIMARY KEY (mes);


--
-- TOC entry 6877 (class 2606 OID 2454685)
-- Name: rdt rdt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rdt
    ADD CONSTRAINT rdt_pkey PRIMARY KEY (rdt);


--
-- TOC entry 6879 (class 2606 OID 2454687)
-- Name: rel rel_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rel
    ADD CONSTRAINT rel_pkey PRIMARY KEY (rel);


--
-- TOC entry 6881 (class 2606 OID 2454689)
-- Name: rgc rgc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rgc
    ADD CONSTRAINT rgc_pkey PRIMARY KEY (rgc);


--
-- TOC entry 6883 (class 2606 OID 2454691)
-- Name: rra rra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rra
    ADD CONSTRAINT rra_pkey PRIMARY KEY (rra);


--
-- TOC entry 6885 (class 2606 OID 2454693)
-- Name: rrc rrc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rrc
    ADD CONSTRAINT rrc_pkey PRIMARY KEY (rrc);


--
-- TOC entry 6887 (class 2606 OID 2454695)
-- Name: rst rst_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.rst
    ADD CONSTRAINT rst_pkey PRIMARY KEY (rst);


--
-- TOC entry 6889 (class 2606 OID 2454697)
-- Name: slt slt_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.slt
    ADD CONSTRAINT slt_pkey PRIMARY KEY (slt);


--
-- TOC entry 6891 (class 2606 OID 2454699)
-- Name: smc smc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.smc
    ADD CONSTRAINT smc_pkey PRIMARY KEY (smc);


--
-- TOC entry 6893 (class 2606 OID 2454701)
-- Name: tra tra_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tra
    ADD CONSTRAINT tra_pkey PRIMARY KEY (tra);


--
-- TOC entry 6895 (class 2606 OID 2454703)
-- Name: tuc tuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.tuc
    ADD CONSTRAINT tuc_pkey PRIMARY KEY (tuc);


--
-- TOC entry 6897 (class 2606 OID 2454705)
-- Name: typ typ_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.typ
    ADD CONSTRAINT typ_pkey PRIMARY KEY (typ);


--
-- TOC entry 6899 (class 2606 OID 2454707)
-- Name: uuc uuc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.uuc
    ADD CONSTRAINT uuc_pkey PRIMARY KEY (uuc);


--
-- TOC entry 6901 (class 2606 OID 2454709)
-- Name: wtc wtc_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wtc
    ADD CONSTRAINT wtc_pkey PRIMARY KEY (wtc);


--
-- TOC entry 6903 (class 2606 OID 2454711)
-- Name: wti wti_pkey; Type: CONSTRAINT; Schema: catalogo_objetos; Owner: postgres
--

ALTER TABLE ONLY catalogo_objetos.wti
    ADD CONSTRAINT wti_pkey PRIMARY KEY (wti);


--
-- TOC entry 6905 (class 2606 OID 2454713)
-- Name: punto_control_p punto_control_p_pkey; Type: CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_pkey PRIMARY KEY (gid);


--
-- TOC entry 6908 (class 2606 OID 2454715)
-- Name: cementerio_a cementerio_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6911 (class 2606 OID 2454717)
-- Name: cerca_l cerca_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6914 (class 2606 OID 2454719)
-- Name: escalinata_a escalinata_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6917 (class 2606 OID 2454721)
-- Name: muro_l muro_l_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6920 (class 2606 OID 2454723)
-- Name: plaza_publica_a plaza_publica_a_pkey; Type: CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6923 (class 2606 OID 2454725)
-- Name: edificio_a edificio_a_pkey; Type: CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6926 (class 2606 OID 2454727)
-- Name: cancha_a cancha_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6929 (class 2606 OID 2454729)
-- Name: estadio_a estadio_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6932 (class 2606 OID 2454731)
-- Name: parque_a parque_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6935 (class 2606 OID 2454733)
-- Name: piscina_a piscina_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6938 (class 2606 OID 2454735)
-- Name: plaza_toros_a plaza_toros_a_pkey; Type: CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6941 (class 2606 OID 2454737)
-- Name: acequia_l acequia_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6944 (class 2606 OID 2454739)
-- Name: acueducto_canal_a acueducto_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6947 (class 2606 OID 2454741)
-- Name: lago_laguna_a lago_laguna_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6950 (class 2606 OID 2454743)
-- Name: rio_a rio_a_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6953 (class 2606 OID 2454745)
-- Name: rio_l rio_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6957 (class 2606 OID 2454747)
-- Name: zanja_l zanja_l_pkey; Type: CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6959 (class 2606 OID 2454749)
-- Name: puerto_a puerto_a_pkey; Type: CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6962 (class 2606 OID 2454751)
-- Name: granja_acuatica_a granja_acuatica_a_pkey; Type: CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6965 (class 2606 OID 2454753)
-- Name: isla_a isla_a_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6968 (class 2606 OID 2454755)
-- Name: orilla_l orilla_l_pkey; Type: CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6971 (class 2606 OID 2454757)
-- Name: invernadero_a hacienda_a_pkey; Type: CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT hacienda_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6974 (class 2606 OID 2454759)
-- Name: acera_a acera_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6977 (class 2606 OID 2454761)
-- Name: bordillo_l bordillo_l_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 6980 (class 2606 OID 2454763)
-- Name: cuneta_a cuneta_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6983 (class 2606 OID 2454765)
-- Name: parqueadero_a parqueadero_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6986 (class 2606 OID 2454767)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6989 (class 2606 OID 2454769)
-- Name: tunel_a tunel_a_pkey; Type: CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6992 (class 2606 OID 2454771)
-- Name: puente_a puente_a_pkey; Type: CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6995 (class 2606 OID 2454773)
-- Name: ferrocarril_a ferrocarril_a_pkey; Type: CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 6998 (class 2606 OID 2454775)
-- Name: gasolinera_a gasolinera_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7001 (class 2606 OID 2454777)
-- Name: intercambiador_vial_a intercambiador_vial_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7004 (class 2606 OID 2454779)
-- Name: rodera_l rodera_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7007 (class 2606 OID 2454781)
-- Name: sendero_l sendero_l_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_pkey PRIMARY KEY (gid);


--
-- TOC entry 7011 (class 2606 OID 2454783)
-- Name: via_ruta_a via_ruta_a_pkey; Type: CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_pkey PRIMARY KEY (gid);


--
-- TOC entry 7013 (class 2606 OID 2454785)
-- Name: qgis_projects qgis_projects_pkey; Type: CONSTRAINT; Schema: proyecto_qgis3; Owner: postgres
--

ALTER TABLE ONLY proyecto_qgis3.qgis_projects
    ADD CONSTRAINT qgis_projects_pkey PRIMARY KEY (name);


--
-- TOC entry 6847 (class 1259 OID 2454786)
-- Name: sidx_aeropuerto_a; Type: INDEX; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE INDEX sidx_aeropuerto_a ON a_aeropuerto_superficie.aeropuerto_a USING gist (the_geom);

ALTER TABLE a_aeropuerto_superficie.aeropuerto_a CLUSTER ON sidx_aeropuerto_a;


--
-- TOC entry 6906 (class 1259 OID 2454787)
-- Name: sidx_punto_control_p; Type: INDEX; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE INDEX sidx_punto_control_p ON d_linderos_propiedad.punto_control_p USING gist (the_geom);


--
-- TOC entry 6909 (class 1259 OID 2454788)
-- Name: sidx_cementerio_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cementerio_a ON gs_asociado_poblados.cementerio_a USING gist (the_geom);


--
-- TOC entry 6912 (class 1259 OID 2454789)
-- Name: sidx_cerca_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_cerca_l ON gs_asociado_poblados.cerca_l USING gist (the_geom);


--
-- TOC entry 6915 (class 1259 OID 2454790)
-- Name: sidx_escalinata_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_escalinata_a ON gs_asociado_poblados.escalinata_a USING gist (the_geom);


--
-- TOC entry 6918 (class 1259 OID 2454791)
-- Name: sidx_muro_l; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_muro_l ON gs_asociado_poblados.muro_l USING gist (the_geom);


--
-- TOC entry 6921 (class 1259 OID 2454792)
-- Name: sidx_plaza_publica_a; Type: INDEX; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE INDEX sidx_plaza_publica_a ON gs_asociado_poblados.plaza_publica_a USING gist (the_geom);


--
-- TOC entry 6924 (class 1259 OID 2454793)
-- Name: sidx_edificio_a; Type: INDEX; Schema: gs_construcciones; Owner: postgres
--

CREATE INDEX sidx_edificio_a ON gs_construcciones.edificio_a USING gist (the_geom);

ALTER TABLE gs_construcciones.edificio_a CLUSTER ON sidx_edificio_a;


--
-- TOC entry 6927 (class 1259 OID 2454794)
-- Name: sidx_cancha_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_cancha_a ON gs_recreacion.cancha_a USING gist (the_geom);


--
-- TOC entry 6930 (class 1259 OID 2454795)
-- Name: sidx_estadio_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_estadio_a ON gs_recreacion.estadio_a USING gist (the_geom);


--
-- TOC entry 6933 (class 1259 OID 2454796)
-- Name: sidx_parque_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_parque_a ON gs_recreacion.parque_a USING gist (the_geom);


--
-- TOC entry 6936 (class 1259 OID 2454797)
-- Name: sidx_piscina_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_piscina_a ON gs_recreacion.piscina_a USING gist (the_geom);


--
-- TOC entry 6939 (class 1259 OID 2454798)
-- Name: sidx_plaza_toros_a; Type: INDEX; Schema: gs_recreacion; Owner: postgres
--

CREATE INDEX sidx_plaza_toros_a ON gs_recreacion.plaza_toros_a USING gist (the_geom);


--
-- TOC entry 6942 (class 1259 OID 2454799)
-- Name: sidx_acequia_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acequia_l ON ho_aguas_interiores.acequia_l USING gist (the_geom);


--
-- TOC entry 6945 (class 1259 OID 2454800)
-- Name: sidx_acueducto_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_acueducto_a ON ho_aguas_interiores.acueducto_canal_a USING gist (the_geom);


--
-- TOC entry 6948 (class 1259 OID 2454801)
-- Name: sidx_lago_laguna_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_lago_laguna_a ON ho_aguas_interiores.lago_laguna_a USING gist (the_geom);


--
-- TOC entry 6951 (class 1259 OID 2454802)
-- Name: sidx_rio_a; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_a ON ho_aguas_interiores.rio_a USING gist (the_geom);


--
-- TOC entry 6954 (class 1259 OID 2454803)
-- Name: sidx_rio_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_rio_l ON ho_aguas_interiores.rio_l USING gist (the_geom);

ALTER TABLE ho_aguas_interiores.rio_l CLUSTER ON sidx_rio_l;


--
-- TOC entry 6955 (class 1259 OID 2454804)
-- Name: sidx_zanja_l; Type: INDEX; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE INDEX sidx_zanja_l ON ho_aguas_interiores.zanja_l USING gist (the_geom);


--
-- TOC entry 6960 (class 1259 OID 2454805)
-- Name: sidx_puerto_a; Type: INDEX; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE INDEX sidx_puerto_a ON ho_puertos_muelles.puerto_a USING gist (the_geom);


--
-- TOC entry 6963 (class 1259 OID 2454806)
-- Name: sidx_granja_acuatica_a; Type: INDEX; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE INDEX sidx_granja_acuatica_a ON ho_regulacion_zonas_restringidas.granja_acuatica_a USING gist (the_geom);


--
-- TOC entry 6966 (class 1259 OID 2454807)
-- Name: sidx_isla_a; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_isla_a ON ho_zonas_costeras.isla_a USING gist (the_geom);


--
-- TOC entry 6969 (class 1259 OID 2454808)
-- Name: sidx_orilla_l; Type: INDEX; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE INDEX sidx_orilla_l ON ho_zonas_costeras.orilla_l USING gist (the_geom);


--
-- TOC entry 6972 (class 1259 OID 2454809)
-- Name: sidx_hacienda_a; Type: INDEX; Schema: ii_agropecuaria; Owner: postgres
--

CREATE INDEX sidx_hacienda_a ON ii_agropecuaria.invernadero_a USING gist (the_geom);


--
-- TOC entry 6975 (class 1259 OID 2454810)
-- Name: acera_a_sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX acera_a_sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.acera_a USING gist (the_geom);


--
-- TOC entry 6978 (class 1259 OID 2454811)
-- Name: bordillo_l_sidx_bordillo_l; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX bordillo_l_sidx_bordillo_l ON it_asociado_transportacion.bordillo_l USING gist (the_geom);


--
-- TOC entry 6981 (class 1259 OID 2454812)
-- Name: cuneta_a_sidx_cuneta_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX cuneta_a_sidx_cuneta_a ON it_asociado_transportacion.cuneta_a USING gist (the_geom);


--
-- TOC entry 6984 (class 1259 OID 2454813)
-- Name: sidx_parqueadero_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_parqueadero_a ON it_asociado_transportacion.parqueadero_a USING gist (the_geom);


--
-- TOC entry 6987 (class 1259 OID 2454814)
-- Name: sidx_paseo_peatonal_ciclovia_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX sidx_paseo_peatonal_ciclovia_a ON it_asociado_transportacion.paseo_peatonal_ciclovia_a USING gist (the_geom);


--
-- TOC entry 6990 (class 1259 OID 2454815)
-- Name: tunel_a_sidx_tunel_a; Type: INDEX; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE INDEX tunel_a_sidx_tunel_a ON it_asociado_transportacion.tunel_a USING gist (the_geom);


--
-- TOC entry 6993 (class 1259 OID 2454816)
-- Name: sidx_puente_a; Type: INDEX; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE INDEX sidx_puente_a ON it_cruces_enlaces.puente_a USING gist (the_geom);


--
-- TOC entry 6996 (class 1259 OID 2454817)
-- Name: ferrocarril_a_sidx_ferrocarril_a; Type: INDEX; Schema: it_ferrocarriles; Owner: postgres
--

CREATE INDEX ferrocarril_a_sidx_ferrocarril_a ON it_ferrocarriles.ferrocarril_a USING gist (the_geom);


--
-- TOC entry 6999 (class 1259 OID 2454818)
-- Name: sidx_gasolinera_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_gasolinera_a ON it_transporte_terrestre.gasolinera_a USING gist (the_geom);


--
-- TOC entry 7002 (class 1259 OID 2454819)
-- Name: sidx_intercambiador_vial_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_intercambiador_vial_a ON it_transporte_terrestre.intercambiador_vial_a USING gist (the_geom);


--
-- TOC entry 7005 (class 1259 OID 2454820)
-- Name: sidx_rodera_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_rodera_l ON it_transporte_terrestre.rodera_l USING gist (the_geom);


--
-- TOC entry 7008 (class 1259 OID 2454821)
-- Name: sidx_sendero_l; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_sendero_l ON it_transporte_terrestre.sendero_l USING gist (the_geom);


--
-- TOC entry 7009 (class 1259 OID 2454822)
-- Name: sidx_via_ruta_a; Type: INDEX; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE INDEX sidx_via_ruta_a ON it_transporte_terrestre.via_ruta_a USING gist (the_geom);


--
-- TOC entry 7297 (class 2618 OID 2454823)
-- Name: aeropuerto_a omitir_duplicados; Type: RULE; Schema: a_aeropuerto_superficie; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO a_aeropuerto_superficie.aeropuerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM a_aeropuerto_superficie.aeropuerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7298 (class 2618 OID 2454825)
-- Name: punto_control_p omitir_duplicados; Type: RULE; Schema: d_linderos_propiedad; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO d_linderos_propiedad.punto_control_p
   WHERE (0 <> ( SELECT count(*) AS count
           FROM d_linderos_propiedad.punto_control_p a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7299 (class 2618 OID 2454827)
-- Name: plaza_publica_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.plaza_publica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.plaza_publica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7300 (class 2618 OID 2454829)
-- Name: muro_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.muro_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.muro_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7301 (class 2618 OID 2454831)
-- Name: escalinata_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.escalinata_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.escalinata_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7302 (class 2618 OID 2454833)
-- Name: cerca_l omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cerca_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cerca_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7303 (class 2618 OID 2454835)
-- Name: cementerio_a omitir_duplicados; Type: RULE; Schema: gs_asociado_poblados; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_asociado_poblados.cementerio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_asociado_poblados.cementerio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7304 (class 2618 OID 2454837)
-- Name: edificio_a omitir_duplicados; Type: RULE; Schema: gs_construcciones; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_construcciones.edificio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_construcciones.edificio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7305 (class 2618 OID 2454839)
-- Name: plaza_toros_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.plaza_toros_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.plaza_toros_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7306 (class 2618 OID 2454841)
-- Name: piscina_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.piscina_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.piscina_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7307 (class 2618 OID 2454843)
-- Name: parque_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.parque_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.parque_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7308 (class 2618 OID 2454845)
-- Name: estadio_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.estadio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.estadio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7309 (class 2618 OID 2454847)
-- Name: cancha_a omitir_duplicados; Type: RULE; Schema: gs_recreacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO gs_recreacion.cancha_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM gs_recreacion.cancha_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7310 (class 2618 OID 2454849)
-- Name: zanja_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.zanja_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.zanja_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7311 (class 2618 OID 2454851)
-- Name: rio_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7312 (class 2618 OID 2454853)
-- Name: rio_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.rio_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.rio_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7313 (class 2618 OID 2454855)
-- Name: lago_laguna_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.lago_laguna_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.lago_laguna_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7314 (class 2618 OID 2454857)
-- Name: acueducto_canal_a omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acueducto_canal_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acueducto_canal_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7315 (class 2618 OID 2454859)
-- Name: acequia_l omitir_duplicados; Type: RULE; Schema: ho_aguas_interiores; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_aguas_interiores.acequia_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_aguas_interiores.acequia_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7316 (class 2618 OID 2454861)
-- Name: puerto_a omitir_duplicados; Type: RULE; Schema: ho_puertos_muelles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_puertos_muelles.puerto_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_puertos_muelles.puerto_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7317 (class 2618 OID 2454863)
-- Name: granja_acuatica_a omitir_duplicados; Type: RULE; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_regulacion_zonas_restringidas.granja_acuatica_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_regulacion_zonas_restringidas.granja_acuatica_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7318 (class 2618 OID 2454865)
-- Name: orilla_l omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.orilla_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.orilla_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7319 (class 2618 OID 2454867)
-- Name: isla_a omitir_duplicados; Type: RULE; Schema: ho_zonas_costeras; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ho_zonas_costeras.isla_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ho_zonas_costeras.isla_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7320 (class 2618 OID 2454869)
-- Name: invernadero_a omitir_duplicados; Type: RULE; Schema: ii_agropecuaria; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO ii_agropecuaria.invernadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM ii_agropecuaria.invernadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7321 (class 2618 OID 2454871)
-- Name: paseo_peatonal_ciclovia_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.paseo_peatonal_ciclovia_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7322 (class 2618 OID 2454873)
-- Name: parqueadero_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.parqueadero_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.parqueadero_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7323 (class 2618 OID 2454875)
-- Name: bordillo_l omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.bordillo_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.bordillo_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7324 (class 2618 OID 2454877)
-- Name: acera_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.acera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.paseo_peatonal_ciclovia_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7325 (class 2618 OID 2454879)
-- Name: tunel_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.tunel_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.tunel_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7326 (class 2618 OID 2454881)
-- Name: cuneta_a omitir_duplicados; Type: RULE; Schema: it_asociado_transportacion; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_asociado_transportacion.cuneta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_asociado_transportacion.cuneta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7327 (class 2618 OID 2454883)
-- Name: puente_a omitir_duplicados; Type: RULE; Schema: it_cruces_enlaces; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_cruces_enlaces.puente_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_cruces_enlaces.puente_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7328 (class 2618 OID 2454885)
-- Name: ferrocarril_a omitir_duplicados; Type: RULE; Schema: it_ferrocarriles; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_ferrocarriles.ferrocarril_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_ferrocarriles.ferrocarril_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7329 (class 2618 OID 2454887)
-- Name: via_ruta_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.via_ruta_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.via_ruta_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7330 (class 2618 OID 2454889)
-- Name: sendero_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.sendero_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.sendero_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7331 (class 2618 OID 2454891)
-- Name: rodera_l omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.rodera_l
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.rodera_l a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7332 (class 2618 OID 2454893)
-- Name: intercambiador_vial_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.intercambiador_vial_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.intercambiador_vial_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7333 (class 2618 OID 2454895)
-- Name: gasolinera_a omitir_duplicados; Type: RULE; Schema: it_transporte_terrestre; Owner: postgres
--

CREATE RULE omitir_duplicados AS
    ON INSERT TO it_transporte_terrestre.gasolinera_a
   WHERE (0 <> ( SELECT count(*) AS count
           FROM it_transporte_terrestre.gasolinera_a a
          WHERE (a.the_geom OPERATOR(public.~=) new.the_geom))) DO NOTHING;


--
-- TOC entry 7014 (class 2606 OID 2454897)
-- Name: aeropuerto_a aeropuerto_a_fk; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7015 (class 2606 OID 2454902)
-- Name: aeropuerto_a aeropuerto_a_fk1; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7016 (class 2606 OID 2454907)
-- Name: aeropuerto_a aeropuerto_a_fk2; Type: FK CONSTRAINT; Schema: a_aeropuerto_superficie; Owner: postgres
--

ALTER TABLE ONLY a_aeropuerto_superficie.aeropuerto_a
    ADD CONSTRAINT aeropuerto_a_fk2 FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7017 (class 2606 OID 2454912)
-- Name: punto_control_p punto_control_p_fk; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7018 (class 2606 OID 2454917)
-- Name: punto_control_p punto_control_p_fk1; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7019 (class 2606 OID 2454922)
-- Name: punto_control_p punto_control_p_fk2; Type: FK CONSTRAINT; Schema: d_linderos_propiedad; Owner: postgres
--

ALTER TABLE ONLY d_linderos_propiedad.punto_control_p
    ADD CONSTRAINT punto_control_p_fk2 FOREIGN KEY (ela) REFERENCES catalogo_objetos.ela(ela);


--
-- TOC entry 7020 (class 2606 OID 2454927)
-- Name: cementerio_a cementerio_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7021 (class 2606 OID 2454932)
-- Name: cementerio_a cementerio_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cementerio_a
    ADD CONSTRAINT cementerio_a_fk1 FOREIGN KEY (rel) REFERENCES catalogo_objetos.rel(rel);


--
-- TOC entry 7022 (class 2606 OID 2454937)
-- Name: cerca_l cerca_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7023 (class 2606 OID 2454942)
-- Name: cerca_l cerca_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk1 FOREIGN KEY (fti) REFERENCES catalogo_objetos.fti(fti);


--
-- TOC entry 7024 (class 2606 OID 2454947)
-- Name: cerca_l cerca_l_fk2; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.cerca_l
    ADD CONSTRAINT cerca_l_fk2 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7025 (class 2606 OID 2454952)
-- Name: escalinata_a escalinata_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7026 (class 2606 OID 2454957)
-- Name: escalinata_a escalinata_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.escalinata_a
    ADD CONSTRAINT escalinata_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7027 (class 2606 OID 2454962)
-- Name: muro_l muro_l_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7028 (class 2606 OID 2454967)
-- Name: muro_l muro_l_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.muro_l
    ADD CONSTRAINT muro_l_fk1 FOREIGN KEY (wti) REFERENCES catalogo_objetos.wti(wti);


--
-- TOC entry 7029 (class 2606 OID 2454972)
-- Name: plaza_publica_a plaza_publica_a_fk; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7030 (class 2606 OID 2454977)
-- Name: plaza_publica_a plaza_publica_a_fk1; Type: FK CONSTRAINT; Schema: gs_asociado_poblados; Owner: postgres
--

ALTER TABLE ONLY gs_asociado_poblados.plaza_publica_a
    ADD CONSTRAINT plaza_publica_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7031 (class 2606 OID 2454982)
-- Name: edificio_a edificio_a_fk; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7032 (class 2606 OID 2454987)
-- Name: edificio_a edificio_a_fk1; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7033 (class 2606 OID 2454992)
-- Name: edificio_a edificio_a_fk2; Type: FK CONSTRAINT; Schema: gs_construcciones; Owner: postgres
--

ALTER TABLE ONLY gs_construcciones.edificio_a
    ADD CONSTRAINT edificio_a_fk2 FOREIGN KEY (uuc) REFERENCES catalogo_objetos.uuc(uuc);


--
-- TOC entry 7034 (class 2606 OID 2454997)
-- Name: cancha_a cancha_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7035 (class 2606 OID 2455002)
-- Name: cancha_a cancha_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7036 (class 2606 OID 2455007)
-- Name: cancha_a cancha_a_fk2; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.cancha_a
    ADD CONSTRAINT cancha_a_fk2 FOREIGN KEY (kos) REFERENCES catalogo_objetos.kos(kos);


--
-- TOC entry 7037 (class 2606 OID 2455012)
-- Name: estadio_a estadio_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7038 (class 2606 OID 2455017)
-- Name: estadio_a estadio_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.estadio_a
    ADD CONSTRAINT estadio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7039 (class 2606 OID 2455022)
-- Name: parque_a parque_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7040 (class 2606 OID 2455027)
-- Name: parque_a parque_a_fk1; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.parque_a
    ADD CONSTRAINT parque_a_fk1 FOREIGN KEY (fuc) REFERENCES catalogo_objetos.fuc(fuc);


--
-- TOC entry 7041 (class 2606 OID 2455032)
-- Name: piscina_a piscina_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.piscina_a
    ADD CONSTRAINT piscina_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7042 (class 2606 OID 2455037)
-- Name: plaza_toros_a plaza_toros_a_fk; Type: FK CONSTRAINT; Schema: gs_recreacion; Owner: postgres
--

ALTER TABLE ONLY gs_recreacion.plaza_toros_a
    ADD CONSTRAINT plaza_toros_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7043 (class 2606 OID 2455042)
-- Name: acequia_l acequia_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7044 (class 2606 OID 2455047)
-- Name: acequia_l acequia_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7045 (class 2606 OID 2455052)
-- Name: acequia_l acequia_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acequia_l
    ADD CONSTRAINT acequia_l_fk2 FOREIGN KEY (dit) REFERENCES catalogo_objetos.dit(dit);


--
-- TOC entry 7046 (class 2606 OID 2455057)
-- Name: acueducto_canal_a acueducto_canal_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7047 (class 2606 OID 2455062)
-- Name: acueducto_canal_a acueducto_canal_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk1 FOREIGN KEY (atc) REFERENCES catalogo_objetos.atc(atc);


--
-- TOC entry 7048 (class 2606 OID 2455067)
-- Name: acueducto_canal_a acueducto_canal_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.acueducto_canal_a
    ADD CONSTRAINT acueducto_canal_a_fk2 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7049 (class 2606 OID 2455072)
-- Name: lago_laguna_a lago_laguna_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7050 (class 2606 OID 2455077)
-- Name: lago_laguna_a lago_laguna_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.lago_laguna_a
    ADD CONSTRAINT lago_laguna_a_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7051 (class 2606 OID 2455082)
-- Name: rio_a rio_a_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7052 (class 2606 OID 2455087)
-- Name: rio_a rio_a_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7053 (class 2606 OID 2455092)
-- Name: rio_a rio_a_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_a
    ADD CONSTRAINT rio_a_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7054 (class 2606 OID 2455097)
-- Name: rio_l rio_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7055 (class 2606 OID 2455102)
-- Name: rio_l rio_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7056 (class 2606 OID 2455107)
-- Name: rio_l rio_l_fk2; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.rio_l
    ADD CONSTRAINT rio_l_fk2 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7057 (class 2606 OID 2455112)
-- Name: zanja_l zanja_l_fk; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7058 (class 2606 OID 2455117)
-- Name: zanja_l zanja_l_fk1; Type: FK CONSTRAINT; Schema: ho_aguas_interiores; Owner: postgres
--

ALTER TABLE ONLY ho_aguas_interiores.zanja_l
    ADD CONSTRAINT zanja_l_fk1 FOREIGN KEY (hyp) REFERENCES catalogo_objetos.hyp(hyp);


--
-- TOC entry 7059 (class 2606 OID 2455122)
-- Name: puerto_a puerto_a_fk; Type: FK CONSTRAINT; Schema: ho_puertos_muelles; Owner: postgres
--

ALTER TABLE ONLY ho_puertos_muelles.puerto_a
    ADD CONSTRAINT puerto_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7060 (class 2606 OID 2455127)
-- Name: granja_acuatica_a granja_acuatica_a_fk; Type: FK CONSTRAINT; Schema: ho_regulacion_zonas_restringidas; Owner: postgres
--

ALTER TABLE ONLY ho_regulacion_zonas_restringidas.granja_acuatica_a
    ADD CONSTRAINT granja_acuatica_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7061 (class 2606 OID 2455132)
-- Name: isla_a isla_a_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.isla_a
    ADD CONSTRAINT isla_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7062 (class 2606 OID 2455137)
-- Name: orilla_l orilla_l_fk; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7063 (class 2606 OID 2455142)
-- Name: orilla_l orilla_l_fk1; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7064 (class 2606 OID 2455147)
-- Name: orilla_l orilla_l_fk2; Type: FK CONSTRAINT; Schema: ho_zonas_costeras; Owner: postgres
--

ALTER TABLE ONLY ho_zonas_costeras.orilla_l
    ADD CONSTRAINT orilla_l_fk2 FOREIGN KEY (slt) REFERENCES catalogo_objetos.slt(slt);


--
-- TOC entry 7065 (class 2606 OID 2455152)
-- Name: invernadero_a invernadero_a_fk; Type: FK CONSTRAINT; Schema: ii_agropecuaria; Owner: postgres
--

ALTER TABLE ONLY ii_agropecuaria.invernadero_a
    ADD CONSTRAINT invernadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7066 (class 2606 OID 2455157)
-- Name: acera_a acera_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7067 (class 2606 OID 2455162)
-- Name: acera_a acera_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.acera_a
    ADD CONSTRAINT acera_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7068 (class 2606 OID 2455167)
-- Name: bordillo_l bordillo_l_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7069 (class 2606 OID 2455172)
-- Name: bordillo_l bordillo_l_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.bordillo_l
    ADD CONSTRAINT bordillo_l_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7070 (class 2606 OID 2455177)
-- Name: cuneta_a cuneta_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7071 (class 2606 OID 2455182)
-- Name: cuneta_a cuneta_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.cuneta_a
    ADD CONSTRAINT cuneta_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7072 (class 2606 OID 2455187)
-- Name: parqueadero_a parqueadero_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7073 (class 2606 OID 2455192)
-- Name: parqueadero_a parqueadero_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.parqueadero_a
    ADD CONSTRAINT parqueadero_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7074 (class 2606 OID 2455197)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7075 (class 2606 OID 2455202)
-- Name: paseo_peatonal_ciclovia_a paseo_peatonal_ciclovia_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.paseo_peatonal_ciclovia_a
    ADD CONSTRAINT paseo_peatonal_ciclovia_a_fk1 FOREIGN KEY (smc) REFERENCES catalogo_objetos.smc(smc);


--
-- TOC entry 7076 (class 2606 OID 2455207)
-- Name: tunel_a tunel_a_fk; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7077 (class 2606 OID 2455212)
-- Name: tunel_a tunel_a_fk1; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk1 FOREIGN KEY (tra) REFERENCES catalogo_objetos.tra(tra);


--
-- TOC entry 7078 (class 2606 OID 2455217)
-- Name: tunel_a tunel_a_fk2; Type: FK CONSTRAINT; Schema: it_asociado_transportacion; Owner: postgres
--

ALTER TABLE ONLY it_asociado_transportacion.tunel_a
    ADD CONSTRAINT tunel_a_fk2 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7079 (class 2606 OID 2455222)
-- Name: puente_a puente_a_fk; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7080 (class 2606 OID 2455227)
-- Name: puente_a puente_a_fk1; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7081 (class 2606 OID 2455232)
-- Name: puente_a puente_a_fk2; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk2 FOREIGN KEY (bsc) REFERENCES catalogo_objetos.bsc(bsc);


--
-- TOC entry 7082 (class 2606 OID 2455237)
-- Name: puente_a puente_a_fk3; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7083 (class 2606 OID 2455242)
-- Name: puente_a puente_a_fk4; Type: FK CONSTRAINT; Schema: it_cruces_enlaces; Owner: postgres
--

ALTER TABLE ONLY it_cruces_enlaces.puente_a
    ADD CONSTRAINT puente_a_fk4 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7084 (class 2606 OID 2455247)
-- Name: ferrocarril_a ferrocarril_a_fk; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7085 (class 2606 OID 2455252)
-- Name: ferrocarril_a ferrocarril_a_fk1; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7086 (class 2606 OID 2455257)
-- Name: ferrocarril_a ferrocarril_a_fk2; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk2 FOREIGN KEY (fco) REFERENCES catalogo_objetos.fco(fco);


--
-- TOC entry 7087 (class 2606 OID 2455262)
-- Name: ferrocarril_a ferrocarril_a_fk3; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7088 (class 2606 OID 2455267)
-- Name: ferrocarril_a ferrocarril_a_fk4; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk4 FOREIGN KEY (rgc) REFERENCES catalogo_objetos.rgc(rgc);


--
-- TOC entry 7089 (class 2606 OID 2455272)
-- Name: ferrocarril_a ferrocarril_a_fk5; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk5 FOREIGN KEY (rra) REFERENCES catalogo_objetos.rra(rra);


--
-- TOC entry 7090 (class 2606 OID 2455277)
-- Name: ferrocarril_a ferrocarril_a_fk6; Type: FK CONSTRAINT; Schema: it_ferrocarriles; Owner: postgres
--

ALTER TABLE ONLY it_ferrocarriles.ferrocarril_a
    ADD CONSTRAINT ferrocarril_a_fk6 FOREIGN KEY (rrc) REFERENCES catalogo_objetos.rrc(rrc);


--
-- TOC entry 7091 (class 2606 OID 2455282)
-- Name: gasolinera_a gasolinera_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.gasolinera_a
    ADD CONSTRAINT gasolinera_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7092 (class 2606 OID 2455287)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7093 (class 2606 OID 2455292)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk1 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7094 (class 2606 OID 2455297)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7095 (class 2606 OID 2455302)
-- Name: intercambiador_vial_a intercambiador_vial_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.intercambiador_vial_a
    ADD CONSTRAINT intercambiador_vial_a_fk3 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7096 (class 2606 OID 2455307)
-- Name: rodera_l rodera_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7097 (class 2606 OID 2455312)
-- Name: rodera_l rodera_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk1 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7098 (class 2606 OID 2455317)
-- Name: rodera_l rodera_l_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7099 (class 2606 OID 2455322)
-- Name: rodera_l rodera_l_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk3 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7100 (class 2606 OID 2455327)
-- Name: rodera_l rodera_l_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk4 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7101 (class 2606 OID 2455332)
-- Name: rodera_l rodera_l_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk5 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7102 (class 2606 OID 2455337)
-- Name: rodera_l rodera_l_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.rodera_l
    ADD CONSTRAINT rodera_l_fk6 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


--
-- TOC entry 7103 (class 2606 OID 2455342)
-- Name: sendero_l sendero_l_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7104 (class 2606 OID 2455347)
-- Name: sendero_l sendero_l_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.sendero_l
    ADD CONSTRAINT sendero_l_fk1 FOREIGN KEY (wtc) REFERENCES catalogo_objetos.wtc(wtc);


--
-- TOC entry 7105 (class 2606 OID 2455352)
-- Name: via_ruta_a via_ruta_a_fk; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk FOREIGN KEY (fcode) REFERENCES catalogo_objetos.catalogo_objetos(fcode);


--
-- TOC entry 7106 (class 2606 OID 2455357)
-- Name: via_ruta_a via_ruta_a_fk1; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk1 FOREIGN KEY (acc) REFERENCES catalogo_objetos.acc(acc);


--
-- TOC entry 7107 (class 2606 OID 2455362)
-- Name: via_ruta_a via_ruta_a_fk2; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk2 FOREIGN KEY (rst) REFERENCES catalogo_objetos.rst(rst);


--
-- TOC entry 7108 (class 2606 OID 2455367)
-- Name: via_ruta_a via_ruta_a_fk3; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk3 FOREIGN KEY (typ) REFERENCES catalogo_objetos.typ(typ);


--
-- TOC entry 7109 (class 2606 OID 2455372)
-- Name: via_ruta_a via_ruta_a_fk4; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk4 FOREIGN KEY (hct) REFERENCES catalogo_objetos.hct(hct);


--
-- TOC entry 7110 (class 2606 OID 2455377)
-- Name: via_ruta_a via_ruta_a_fk5; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk5 FOREIGN KEY (loc) REFERENCES catalogo_objetos.loc(loc);


--
-- TOC entry 7111 (class 2606 OID 2455382)
-- Name: via_ruta_a via_ruta_a_fk6; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk6 FOREIGN KEY (mes) REFERENCES catalogo_objetos.mes(mes);


--
-- TOC entry 7112 (class 2606 OID 2455387)
-- Name: via_ruta_a via_ruta_a_fk7; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk7 FOREIGN KEY (rdt) REFERENCES catalogo_objetos.rdt(rdt);


--
-- TOC entry 7113 (class 2606 OID 2455392)
-- Name: via_ruta_a via_ruta_a_fk8; Type: FK CONSTRAINT; Schema: it_transporte_terrestre; Owner: postgres
--

ALTER TABLE ONLY it_transporte_terrestre.via_ruta_a
    ADD CONSTRAINT via_ruta_a_fk8 FOREIGN KEY (tuc) REFERENCES catalogo_objetos.tuc(tuc);


-- Completed on 2022-08-25 14:58:28

--
-- PostgreSQL database dump complete
--

